/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field86
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "86";
    public static final String F_86 = "86";
    public static final String PARSER_PATTERN = "S[$S]0-5";
    public static final String COMPONENTS_PATTERN = "SSSSSS";
    public static final Integer NARRATIVE = 1;

    public Field86() {
        super(6);
    }

    public Field86(String value) {
        super(value);
    }

    public Field86(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"86")) {
            throw new IllegalArgumentException("cannot create field 86 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field86 newInstance(Field86 source) {
        Field86 cp = new Field86();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("86", value);
    }

    public static Tag emptyTag() {
        return new Tag("86", "");
    }

    @Override
    public void parse(String value) {
        this.init(6);
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 1, null, 0, lines);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.appendInLines(result, 1, 6);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 86");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "CUSTOM";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        return component == 6;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Narrative");
        result.add("Narrative 2");
        result.add("Narrative 3");
        result.add("Narrative 4");
        result.add("Narrative 5");
        result.add("Narrative 6");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "narrative");
        result.put(2, "narrative2");
        result.put(3, "narrative3");
        result.put(4, "narrative4");
        result.put(5, "narrative5");
        result.put(6, "narrative6");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getNarrativeLine1() {
        return this.getComponent(1);
    }

    public String getNarrativeLine2() {
        return this.getComponent(2);
    }

    public String getNarrativeLine3() {
        return this.getComponent(3);
    }

    public String getNarrativeLine4() {
        return this.getComponent(4);
    }

    public String getNarrativeLine5() {
        return this.getComponent(5);
    }

    public String getNarrativeLine6() {
        return this.getComponent(6);
    }

    public String getNarrative() {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < 7; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent3AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent4AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(4);
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent5AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(5);
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    @Deprecated
    public String getComponent6AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent6AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(6);
    }

    public Field86 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field86 setNarrativeLine1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field86 setNarrativeLine2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field86 setNarrativeLine3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field86 setNarrativeLine4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field86 setNarrativeLine5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field86 setNarrativeLine6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field86 setNarrative(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 1, 6, 0, lines);
        return this;
    }

    public Field86 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field86 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field86 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field86 setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field86 setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    @Override
    public String getName() {
        return "86";
    }

    public static Field86 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("86");
        if (t == null) {
            return null;
        }
        return new Field86(t);
    }

    public static Field86 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field86.get(msg.getBlock4());
    }

    public static List<Field86> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field86.getAll(msg.getBlock4());
    }

    public static List<Field86> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("86");
        if (arr != null && arr.length > 0) {
            ArrayList<Field86> result = new ArrayList<Field86>(arr.length);
            for (Tag f : arr) {
                result.add(new Field86(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field86 cp = Field86.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field86 cp = Field86.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field86 cp = Field86.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field86 fromJson(String json) {
        Field86 field = new Field86();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("narrative") != null) {
            field.setComponent1(jsonObject.get("narrative").getAsString());
        }
        if (jsonObject.get("narrative2") != null) {
            field.setComponent2(jsonObject.get("narrative2").getAsString());
        }
        if (jsonObject.get("narrative3") != null) {
            field.setComponent3(jsonObject.get("narrative3").getAsString());
        }
        if (jsonObject.get("narrative4") != null) {
            field.setComponent4(jsonObject.get("narrative4").getAsString());
        }
        if (jsonObject.get("narrative5") != null) {
            field.setComponent5(jsonObject.get("narrative5").getAsString());
        }
        if (jsonObject.get("narrative6") != null) {
            field.setComponent6(jsonObject.get("narrative6").getAsString());
        }
        return field;
    }
}

