/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field90J
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer,
GenericField {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "90J";
    public static final String F_90J = "90J";
    public static final String PARSER_PATTERN = ":S//S/SN/SN";
    public static final String COMPONENTS_PATTERN = "SSCNCN";
    public static final Integer QUALIFIER = 1;
    public static final Integer CODE = 2;
    public static final Integer CURRENCY1 = 3;
    public static final Integer AMOUNT1 = 4;
    public static final Integer CURRENCY2 = 5;
    public static final Integer AMOUNT2 = 6;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field90J() {
        super(6);
    }

    public Field90J(String value) {
        super(value);
    }

    public Field90J(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"90J")) {
            throw new IllegalArgumentException("cannot create field 90J from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field90J newInstance(Field90J source) {
        Field90J cp = new Field90J();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("90J", value);
    }

    public static Tag emptyTag() {
        return new Tag("90J", "");
    }

    @Override
    public void parse(String value) {
        this.init(6);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        String toparse2 = SwiftParseUtils.getTokenSecondLast(toparse, "/");
        String toparse3 = SwiftParseUtils.getTokenFirst(toparse2, "/");
        this.setComponent3(SwiftParseUtils.getAlphaPrefix(toparse3));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(toparse3));
        String toparse4 = SwiftParseUtils.getTokenSecondLast(toparse2, "/");
        this.setComponent5(SwiftParseUtils.getAlphaPrefix(toparse4));
        this.setComponent6(SwiftParseUtils.getNumericSuffix(toparse4));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        this.append(result, 4);
        result.append("/");
        this.append(result, 5);
        this.append(result, 6);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        NumberFormat f;
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 90J");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent6AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//4!c/<CUR><AMOUNT>15/<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Code");
        result.add("Currency1");
        result.add("Amount1");
        result.add("Currency2");
        result.add("Amount2");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "code");
        result.put(3, "currency1");
        result.put(4, "amount1");
        result.put(5, "currency2");
        result.put(6, "amount2");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getCode() {
        return this.getComponent(2);
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getCurrency1() {
        return this.getComponent(3);
    }

    public Currency getCurrency1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getAmount1() {
        return this.getComponent(4);
    }

    public Number getAmount1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Currency getComponent5AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(5));
    }

    public String getCurrency2() {
        return this.getComponent(5);
    }

    public Currency getCurrency2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(5));
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Number getComponent6AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public String getAmount2() {
        return this.getComponent(6);
    }

    public Number getAmount2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    public Field90J setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field90J setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field90J setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field90J setCode(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field90J setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field90J setComponent3(Currency component3) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(component3));
        return this;
    }

    public Field90J setCurrency1(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field90J setCurrency1(Currency component3) {
        this.setComponent3(component3);
        return this;
    }

    public Field90J setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field90J setComponent4(Number component4) {
        this.setComponent(4, SwiftFormatUtils.getNumber(component4));
        return this;
    }

    public Field90J setAmount1(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field90J setAmount1(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    public Field90J setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field90J setComponent5(Currency component5) {
        this.setComponent(5, SwiftFormatUtils.getCurrency(component5));
        return this;
    }

    public Field90J setCurrency2(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field90J setCurrency2(Currency component5) {
        this.setComponent5(component5);
        return this;
    }

    public Field90J setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field90J setComponent6(Number component6) {
        this.setComponent(6, SwiftFormatUtils.getNumber(component6));
        return this;
    }

    public Field90J setAmount2(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field90J setAmount2(Number component6) {
        this.setComponent6(component6);
        return this;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "90J";
    }

    public static Field90J get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("90J");
        if (t == null) {
            return null;
        }
        return new Field90J(t);
    }

    public static Field90J get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field90J.get(msg.getBlock4());
    }

    public static List<Field90J> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field90J.getAll(msg.getBlock4());
    }

    public static List<Field90J> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("90J");
        if (arr != null && arr.length > 0) {
            ArrayList<Field90J> result = new ArrayList<Field90J>(arr.length);
            for (Tag f : arr) {
                result.add(new Field90J(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field90J fromJson(String json) {
        Field90J field = new Field90J();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent2(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("currency1") != null) {
            field.setComponent3(jsonObject.get("currency1").getAsString());
        }
        if (jsonObject.get("amount1") != null) {
            field.setComponent4(jsonObject.get("amount1").getAsString());
        }
        if (jsonObject.get("currency2") != null) {
            field.setComponent5(jsonObject.get("currency2").getAsString());
        }
        if (jsonObject.get("amount2") != null) {
            field.setComponent6(jsonObject.get("amount2").getAsString());
        }
        return field;
    }
}

