/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field92A
extends Field
implements Serializable,
AmountContainer,
GenericField {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "92A";
    public static final String F_92A = "92A";
    public static final String PARSER_PATTERN = ":S//[c]N";
    public static final String COMPONENTS_PATTERN = "SSN";
    public static final Integer QUALIFIER = 1;
    public static final Integer SIGN = 2;
    public static final Integer RATE_AMOUNT = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field92A() {
        super(3);
    }

    public Field92A(String value) {
        super(value);
    }

    public Field92A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"92A")) {
            throw new IllegalArgumentException("cannot create field 92A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field92A newInstance(Field92A source) {
        Field92A cp = new Field92A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("92A", value);
    }

    public static Tag emptyTag() {
        return new Tag("92A", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getAlphaPrefix(toparse));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 92A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            Number n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//[<N>]<AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Sign");
        result.add("Rate Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "sign");
        result.put(3, "rateAmount");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getSign() {
        return this.getComponent(2);
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getRateAmount() {
        return this.getComponent(3);
    }

    public Number getRateAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    public Field92A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field92A setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field92A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92A setSign(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field92A setComponent3(Number component3) {
        this.setComponent(3, SwiftFormatUtils.getNumber(component3));
        return this;
    }

    public Field92A setRateAmount(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field92A setRateAmount(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "92A";
    }

    public static Field92A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("92A");
        if (t == null) {
            return null;
        }
        return new Field92A(t);
    }

    public static Field92A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field92A.get(msg.getBlock4());
    }

    public static List<Field92A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field92A.getAll(msg.getBlock4());
    }

    public static List<Field92A> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("92A");
        if (arr != null && arr.length > 0) {
            ArrayList<Field92A> result = new ArrayList<Field92A>(arr.length);
            for (Tag f : arr) {
                result.add(new Field92A(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field92A fromJson(String json) {
        Field92A field = new Field92A();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent2(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("rateAmount") != null) {
            field.setComponent3(jsonObject.get("rateAmount").getAsString());
        }
        return field;
    }
}

