/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field98E
extends Field
implements Serializable,
DateContainer,
GenericField {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "98E";
    public static final String F_98E = "98E";
    public static final String PARSER_PATTERN = ":S//<DATE4><TIME2>[,S][/[c]<TIME3>]";
    public static final String COMPONENTS_PATTERN = "SDTNCW";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATE = 2;
    public static final Integer TIME = 3;
    public static final Integer DECIMALS = 4;
    public static final Integer SIGN = 5;
    public static final Integer UTC_INDICATOR = 6;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field98E() {
        super(6);
    }

    public Field98E(String value) {
        super(value);
    }

    public Field98E(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"98E")) {
            throw new IllegalArgumentException("cannot create field 98E from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field98E newInstance(Field98E source) {
        Field98E cp = new Field98E();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("98E", value);
    }

    public static Tag emptyTag() {
        return new Tag("98E", "");
    }

    @Override
    public void parse(String value) {
        this.init(6);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        if (toparse != null) {
            if (toparse.length() >= 8) {
                this.setComponent2(StringUtils.substring((String)toparse, (int)0, (int)8));
            }
            if (toparse.length() >= 14) {
                this.setComponent3(StringUtils.substring((String)toparse, (int)8, (int)14));
            }
            if (toparse.length() > 14) {
                String toparse2 = StringUtils.substring((String)toparse, (int)14);
                this.setComponent4(SwiftParseUtils.getTokenFirst(toparse2, ",", "/"));
                String toparse3 = SwiftParseUtils.getTokenSecondLast(toparse2, "/");
                if (toparse3 != null) {
                    if (toparse3.length() < 2) {
                        this.setComponent5(toparse3);
                    } else if (toparse3.length() == 2 || toparse3.length() == 4) {
                        this.setComponent6(toparse3);
                    } else if (toparse3.length() == 3 || toparse3.length() == 5) {
                        this.setComponent5(StringUtils.substring((String)toparse3, (int)0, (int)1));
                        this.setComponent6(StringUtils.substring((String)toparse3, (int)1));
                    } else if (toparse3.length() > 4) {
                        this.setComponent5(SwiftParseUtils.getAlphaPrefix(toparse3));
                        this.setComponent6(SwiftParseUtils.getNumericSuffix(toparse3));
                    }
                }
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        if (this.getComponent4() != null) {
            result.append(",").append(this.getComponent4());
        }
        if (this.getComponent5() != null || this.getComponent6() != null) {
            result.append("/");
            this.append(result, 5);
            this.append(result, 6);
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        Format f;
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 98E");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            Number n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent6AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<DATE4><TIME2>[,3n][/[<N>]<TIME3>]";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 4) {
            return true;
        }
        return component == 5;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Date");
        result.add("Time");
        result.add("Decimals");
        result.add("Sign");
        result.add("UTC Indicator");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "date");
        result.put(3, "time");
        result.put(4, "decimals");
        result.put(5, "sign");
        result.put(6, "uTCIndicator");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(3));
    }

    public String getTime() {
        return this.getComponent(3);
    }

    public Calendar getTimeAsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(3));
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getDecimals() {
        return this.getComponent(4);
    }

    public Number getDecimalsAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Currency getComponent5AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(5));
    }

    public String getSign() {
        return this.getComponent(5);
    }

    public Currency getSignAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(5));
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Calendar getComponent6AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(6));
    }

    public String getUTCIndicator() {
        return this.getComponent(6);
    }

    public Calendar getUTCIndicatorAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(6));
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(2)));
        result.add(SwiftFormatUtils.getTime2(this.getComponent(3)));
        result.add(SwiftFormatUtils.getTime3(this.getComponent(6)));
        return result;
    }

    public Field98E setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field98E setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field98E setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field98E setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate4(component2));
        return this;
    }

    public Field98E setDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field98E setDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public Field98E setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field98E setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime2(component3));
        return this;
    }

    public Field98E setTime(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field98E setTime(Calendar component3) {
        this.setComponent3(component3);
        return this;
    }

    public Field98E setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field98E setComponent4(Number component4) {
        if (component4 != null) {
            this.setComponent(4, Integer.toString(component4.intValue()));
        }
        return this;
    }

    public Field98E setDecimals(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field98E setDecimals(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    public Field98E setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field98E setComponent5(Currency component5) {
        this.setComponent(5, SwiftFormatUtils.getCurrency(component5));
        return this;
    }

    public Field98E setSign(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field98E setSign(Currency component5) {
        this.setComponent5(component5);
        return this;
    }

    public Field98E setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field98E setComponent6(Calendar component6) {
        this.setComponent(6, SwiftFormatUtils.getTime3(component6));
        return this;
    }

    public Field98E setUTCIndicator(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field98E setUTCIndicator(Calendar component6) {
        this.setComponent6(component6);
        return this;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "98E";
    }

    public static Field98E get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("98E");
        if (t == null) {
            return null;
        }
        return new Field98E(t);
    }

    public static Field98E get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field98E.get(msg.getBlock4());
    }

    public static List<Field98E> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field98E.getAll(msg.getBlock4());
    }

    public static List<Field98E> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("98E");
        if (arr != null && arr.length > 0) {
            ArrayList<Field98E> result = new ArrayList<Field98E>(arr.length);
            for (Tag f : arr) {
                result.add(new Field98E(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field98E fromJson(String json) {
        Field98E field = new Field98E();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent2(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent3(jsonObject.get("time").getAsString());
        }
        if (jsonObject.get("decimals") != null) {
            field.setComponent4(jsonObject.get("decimals").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent5(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("uTCIndicator") != null) {
            field.setComponent6(jsonObject.get("uTCIndicator").getAsString());
        }
        return field;
    }
}

