/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field98H
extends Field
implements Serializable {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "98H";
    public static final String F_98H = "98H";
    public static final String PARSER_PATTERN = "<TIME2>[,S][/[c]<TIME3>]";
    public static final String COMPONENTS_PATTERN = "TNCW";
    public static final Integer TIME = 1;
    public static final Integer NUMBER = 2;
    public static final Integer N = 3;
    public static final Integer TIME_2 = 4;

    public Field98H() {
        super(4);
    }

    public Field98H(String value) {
        super(value);
    }

    public Field98H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"98H")) {
            throw new IllegalArgumentException("cannot create field 98H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field98H newInstance(Field98H source) {
        Field98H cp = new Field98H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("98H", value);
    }

    public static Tag emptyTag() {
        return new Tag("98H", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        if (value != null) {
            String left;
            String right = null;
            if (value.indexOf(47) >= 0) {
                left = SwiftParseUtils.getTokenFirst(value, "/");
                right = SwiftParseUtils.getTokenSecondLast(value, "/");
            } else {
                left = value;
            }
            this.setComponent1(SwiftParseUtils.getTokenFirst(left, ","));
            this.setComponent2(SwiftParseUtils.getTokenSecondLast(left, ","));
            if (right != null) {
                if (right.length() < 2) {
                    this.setComponent3(right);
                } else if (right.length() == 2 || right.length() == 4) {
                    this.setComponent4(right);
                } else if (right.length() == 3 || right.length() == 5) {
                    this.setComponent3(StringUtils.substring((String)right, (int)0, (int)1));
                    this.setComponent4(StringUtils.substring((String)right, (int)1));
                } else if (right.length() > 4) {
                    this.setComponent3(SwiftParseUtils.getAlphaPrefix(right));
                    this.setComponent4(SwiftParseUtils.getNumericSuffix(right));
                }
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append(",").append(this.getComponent2());
        }
        if (this.getComponent3() != null || this.getComponent4() != null) {
            result.append("/");
            this.append(result, 3);
            this.append(result, 4);
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        Format f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 98H");
        }
        if (component == 1) {
            f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 2) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            Number n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<TIME2>[,3n][/[<N>]<TIME3>]";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Time");
        result.add("Number");
        result.add("N");
        result.add("Time 2");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "time");
        result.put(2, "number");
        result.put(3, "n");
        result.put(4, "time2");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(1));
    }

    public String getTime() {
        return this.getComponent(1);
    }

    public Calendar getTimeAsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(1));
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getNumber() {
        return this.getComponent(2);
    }

    public Number getNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getN() {
        return this.getComponent(3);
    }

    public Currency getNAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(4));
    }

    public String getTime2() {
        return this.getComponent(4);
    }

    public Calendar getTime2AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(4));
    }

    public Field98H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field98H setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getTime2(component1));
        return this;
    }

    public Field98H setTime(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field98H setTime(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    public Field98H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field98H setComponent2(Number component2) {
        if (component2 != null) {
            this.setComponent(2, Integer.toString(component2.intValue()));
        }
        return this;
    }

    public Field98H setNumber(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field98H setNumber(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    public Field98H setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field98H setComponent3(Currency component3) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(component3));
        return this;
    }

    public Field98H setN(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field98H setN(Currency component3) {
        this.setComponent3(component3);
        return this;
    }

    public Field98H setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field98H setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getTime3(component4));
        return this;
    }

    public Field98H setTime2(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field98H setTime2(Calendar component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public String getName() {
        return "98H";
    }

    public static Field98H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("98H");
        if (t == null) {
            return null;
        }
        return new Field98H(t);
    }

    public static Field98H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field98H.get(msg.getBlock4());
    }

    public static List<Field98H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field98H.getAll(msg.getBlock4());
    }

    public static List<Field98H> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("98H");
        if (arr != null && arr.length > 0) {
            ArrayList<Field98H> result = new ArrayList<Field98H>(arr.length);
            for (Tag f : arr) {
                result.add(new Field98H(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field98H fromJson(String json) {
        Field98H field = new Field98H();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("time") != null) {
            field.setComponent1(jsonObject.get("time").getAsString());
        }
        if (jsonObject.get("number") != null) {
            field.setComponent2(jsonObject.get("number").getAsString());
        }
        if (jsonObject.get("n") != null) {
            field.setComponent3(jsonObject.get("n").getAsString());
        }
        if (jsonObject.get("time2") != null) {
            field.setComponent4(jsonObject.get("time2").getAsString());
        }
        return field;
    }
}

