/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class OptionPPartyField
extends Field
implements BICContainer {
    public static final String PARSER_PATTERN = ":S//S";
    public static final String COMPONENTS_PATTERN = "SB";
    public static final Integer QUALIFIER = 1;
    public static final Integer BIC = 2;

    public OptionPPartyField() {
        super(2);
    }

    public OptionPPartyField(String value) {
        super(value);
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent(1, SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent(2, SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field " + this.getName());
        }
        return this.getComponent(component);
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public abstract String validatorPattern();

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("BIC");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "bIC");
        return result;
    }

    @Override
    public abstract String getName();

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BIC getComponent2AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public String getBIC() {
        return this.getComponent(2);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> result = new ArrayList<BIC>();
        result.add(SwiftFormatUtils.getBIC(this.getComponent(2)));
        return result;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getComponent(2));
        return result;
    }
}

