/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.JsonSerializable;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.io.ConversionService;
import com.prowidesoftware.swift.io.parser.SwiftParser;
import com.prowidesoftware.swift.io.writer.SwiftWriter;
import com.prowidesoftware.swift.model.AbstractMessage;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.MessageStandardType;
import com.prowidesoftware.swift.model.MtId;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Adapter;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.mt.AbstractMTAdapter;
import com.prowidesoftware.swift.model.mt.MTVariant;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class AbstractMT
extends AbstractMessage
implements JsonSerializable {
    private static final transient Logger log = Logger.getLogger(AbstractMT.class.getName());
    protected SwiftMessage m;
    private static final String GETSEQUENCE = "getSequence";

    public AbstractMT(SwiftMessage m) {
        super(MessageStandardType.MT);
        this.m = m;
    }

    public AbstractMT() {
        super(MessageStandardType.MT);
        this.m = new SwiftMessage(true);
        if (this.getMessageType() != null) {
            this.m.getBlock2().setMessageType(this.getMessageType());
        }
    }

    public AbstractMT(int messageType) {
        this(messageType, "TESTARZZ", "TESTARZZ");
    }

    public AbstractMT(int messageType, String sender, String receiver) {
        super(MessageStandardType.MT);
        this.m = new SwiftMessage(true);
        this.m.getBlock1().setSender(sender);
        SwiftBlock2Input b2 = new SwiftBlock2Input();
        StringBuilder type = new StringBuilder();
        if (messageType < 100) {
            type.append("0");
        }
        type.append(messageType);
        b2.setMessageType(type.toString());
        b2.setInput(true);
        b2.setMessagePriority("N");
        b2.setReceiver(receiver);
        this.m.setBlock2(b2);
    }

    public static AbstractMT parse(String fin) throws IOException {
        return new SwiftParser(fin).message().toMT();
    }

    public static AbstractMT parse(InputStream stream) throws IOException {
        return new SwiftParser(stream).message().toMT();
    }

    public static AbstractMT parse(File file) throws IOException {
        return new SwiftParser(Lib.readFile(file)).message().toMT();
    }

    public SwiftMessage getSwiftMessage() {
        return this.m;
    }

    protected SwiftMessage getSwiftMessageNotNullOrException() {
        if (this.m == null) {
            throw new IllegalStateException("SwiftMessage is null");
        }
        return this.m;
    }

    public void setSwiftMessage(SwiftMessage m) {
        this.m = m;
    }

    public String getApplicationId() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock1() != null) {
            return this.m.getBlock1().getApplicationId();
        }
        return null;
    }

    public String getServiceId() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock1() != null) {
            return this.m.getBlock1().getServiceId();
        }
        return null;
    }

    public String getLogicalTerminal() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock1() != null) {
            return this.m.getBlock1().getLogicalTerminal();
        }
        return null;
    }

    public String getSessionNumber() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock1() != null) {
            return this.m.getBlock1().getSessionNumber();
        }
        return null;
    }

    public String getSequenceNumber() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock1() != null) {
            return this.m.getBlock1().getSequenceNumber();
        }
        return null;
    }

    public String getMessagePriority() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.m.getBlock2() != null) {
            return this.m.getBlock2().getMessagePriority();
        }
        return null;
    }

    public boolean isInput() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        return this.m.isInput();
    }

    public boolean isOutgoing() {
        return this.isInput();
    }

    public boolean isOutput() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        return this.m.isOutput();
    }

    public boolean isIncoming() {
        return this.isOutput();
    }

    public void setSender(String sender) {
        if (this.getSwiftMessage() == null) {
            this.m = new SwiftMessage(true);
        }
        this.getSwiftMessage().getBlock1().setSender(sender);
    }

    public void setSender(BIC bic) {
        if (this.getSwiftMessage() == null) {
            this.m = new SwiftMessage(true);
        }
        this.getSwiftMessage().getBlock1().setLogicalTerminal(bic);
    }

    public String getSender() {
        if (this.getSwiftMessage() != null) {
            return this.getSwiftMessage().getSender();
        }
        return null;
    }

    public void setReceiver(String receiver) {
        SwiftBlock2 b2;
        if (this.getSwiftMessage() == null) {
            this.m = new SwiftMessage(true);
        }
        if ((b2 = this.getSwiftMessage().getBlock2()).isInput()) {
            ((SwiftBlock2Input)b2).setReceiver(receiver);
        }
    }

    public void setReceiver(BIC bic) {
        this.setReceiver(bic.getBic11());
    }

    public String getReceiver() {
        if (this.getSwiftMessage() != null) {
            return this.getSwiftMessage().getReceiver();
        }
        return null;
    }

    public void addField(Field f) {
        if (this.getSwiftMessage() == null) {
            this.m = new SwiftMessage();
        }
        this.getSwiftMessage().getBlock4().append(f);
    }

    @Override
    public String message() {
        ConversionService srv = new ConversionService();
        return srv.getFIN(this.m);
    }

    public abstract String getMessageType();

    public List<SwiftTagListBlock> getSequenceList(String name) {
        String methodName = GETSEQUENCE + name + "List";
        Object o = this.invokeHere(methodName, this, null);
        return (List)o;
    }

    public List<SwiftTagListBlock> getSequenceList(String name, SwiftTagListBlock block) {
        String methodName = GETSEQUENCE + name + "List";
        return (List)this.invokeHere(methodName, this, block);
    }

    public boolean containsSequenceList(String name) {
        try {
            return this.getClass().getMethod(GETSEQUENCE + name + "List", new Class[0]) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean containsSequence(String name) {
        try {
            return this.getClass().getMethod(GETSEQUENCE + name, new Class[0]) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Object invokeHere(String methodName, Object where, SwiftTagListBlock argument) {
        try {
            Method method;
            Method method2 = method = argument == null ? this.getClass().getMethod(methodName, new Class[0]) : this.getClass().getMethod(methodName, SwiftTagListBlock.class);
            if (argument == null) {
                return method.invoke(where, new Object[0]);
            }
            return method.invoke(where, argument);
        }
        catch (NoSuchMethodException e) {
            log.log(Level.FINE, "Method " + methodName + " does not exist in " + this.getClass(), e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "An error occured while invoking " + methodName + " in " + where, e);
        }
        return null;
    }

    public SwiftTagListBlock getSequence(String name) {
        String methodName = GETSEQUENCE + name;
        Object o = this.invokeHere(methodName, this, null);
        return (SwiftTagListBlock)o;
    }

    public SwiftTagListBlock getSequence(String name, SwiftTagListBlock block) {
        String methodName = GETSEQUENCE + name;
        Object o = this.invokeHere(methodName, this, block);
        return (SwiftTagListBlock)o;
    }

    public String toString() {
        return "AbstractMT [m=" + this.m + "]";
    }

    public AbstractMT setSignature(String signature) {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        this.getSwiftMessage().setSignature(signature);
        return this;
    }

    public String getSignature() {
        return this.getSwiftMessage() != null ? this.getSwiftMessage().getSignature() : null;
    }

    public static AbstractMT create(int messageType) {
        return AbstractMT.create(messageType, "TESTARZZ", "TESTARZZ");
    }

    public static AbstractMT create(int messageType, String sender, String receiver) {
        SwiftMessage sm = new SwiftMessage(true);
        SwiftBlock2Input b2 = new SwiftBlock2Input();
        b2.setMessageType(Integer.valueOf(messageType).toString());
        b2.setInput(true);
        b2.setMessagePriority("N");
        b2.setDeliveryMonitoring("2");
        b2.setObsolescencePeriod("020");
        sm.setBlock2(b2);
        AbstractMT result = sm.toMT();
        result.setSender(StringUtils.rightPad((String)sender, (int)12, (char)'X'));
        result.setReceiver(StringUtils.rightPad((String)receiver, (int)12, (char)'X'));
        return result;
    }

    public AbstractMT append(SwiftTagListBlock block) {
        Validate.notNull((Object)block);
        if (!block.isEmpty()) {
            this.b4().addTags(block.getTags());
        }
        return this;
    }

    public AbstractMT append(Tag ... tags) {
        Validate.notNull((Object)tags);
        if (tags.length > 0) {
            for (Tag t : tags) {
                this.b4().append(t);
            }
        }
        return this;
    }

    public AbstractMT append(Field ... fields) {
        Validate.notNull((Object)fields);
        if (fields.length > 0) {
            for (Field t : fields) {
                this.b4().append(t);
            }
        }
        return this;
    }

    private SwiftBlock4 b4() {
        if (this.m == null) {
            throw new IllegalStateException("SwiftMessage is null");
        }
        SwiftBlock4 b4 = this.m.getBlock4();
        if (b4 == null) {
            this.m.setBlock4(new SwiftBlock4());
            return this.m.getBlock4();
        }
        return b4;
    }

    protected static SwiftMessage read(String fin) {
        try {
            return SwiftMessage.parse(fin);
        }
        catch (IOException e) {
            log.severe("An error occured while reading FIN :" + e.getClass().getName());
            log.log(Level.SEVERE, "Read exception");
            log.log(Level.SEVERE, "Read exception while parsing " + fin, e);
            return null;
        }
    }

    public void write(File file) throws IOException {
        Validate.notNull((Object)file, (String)"the file to write cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)this.m, (String)"the message to write cannot be null", (Object[])new Object[0]);
        boolean created = file.createNewFile();
        if (created) {
            log.fine("new file created: " + file.getAbsolutePath());
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        SwiftWriter.writeMessage(this.m, fw, true);
        fw.close();
    }

    public void write(OutputStream stream) throws IOException {
        Validate.notNull((Object)stream, (String)"the stream to write cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)this.m, (String)"the message to write cannot be null", (Object[])new Object[0]);
        stream.write(this.message().getBytes("UTF-8"));
    }

    @Deprecated
    public String json() {
        DeprecationUtils.phase2(this.getClass(), "json()", "use toJson() instead");
        Validate.notNull((Object)this.m, (String)"the message cannot be null", (Object[])new Object[0]);
        return this.m.toJson();
    }

    public String xml() {
        Validate.notNull((Object)this.m, (String)"the message cannot be null", (Object[])new Object[0]);
        return this.m.toXml();
    }

    public boolean isType(Integer type) {
        return this.m.getTypeInt() == type.intValue();
    }

    public static SwiftTagListBlock getSequence(SwiftMessage msg, String sequence) {
        AbstractMT amt;
        if (msg != null && sequence != null && (amt = msg.toMT()) != null) {
            return amt.getSequence(sequence);
        }
        return null;
    }

    public MTVariant getVariant() {
        return this.m.getVariant();
    }

    public String nameFromClass() {
        return StringUtils.substringAfter((String)this.getClass().getName(), (String)".MT");
    }

    public MtId getMtId() {
        return new MtId(this.getMessageType(), this.getVariant());
    }

    protected Tag tag(String tagName) {
        SwiftMessage _m = this.getSwiftMessageNotNullOrException();
        if (_m.getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        return _m.getBlock4().getTagByName(tagName);
    }

    protected Tag[] tags(String tagName) {
        SwiftMessage _m = this.getSwiftMessageNotNullOrException();
        if (_m.getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        return _m.getBlock4().getTagsByName(tagName);
    }

    @Override
    public String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbstractMT.class, (Object)new AbstractMTAdapter()).setPrettyPrinting().create();
        return gson.toJson((Object)this, AbstractMT.class);
    }

    public static AbstractMT fromJson(String json) {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbstractMT.class, (Object)new AbstractMTAdapter()).registerTypeAdapter(SwiftBlock2.class, (Object)new SwiftBlock2Adapter()).create();
        return (AbstractMT)gson.fromJson(json, AbstractMT.class);
    }

    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Tag tag : this.m.getBlock4().getTags()) {
            fields.add(tag.asField());
        }
        return fields;
    }
}

