/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt2xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field13C;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field53D;
import com.prowidesoftware.swift.model.field.Field56A;
import com.prowidesoftware.swift.model.field.Field56D;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57B;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field58A;
import com.prowidesoftware.swift.model.field.Field58D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT205
extends AbstractMT
implements Serializable {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT205.class.getName());
    public static final String NAME = "205";

    public MT205(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT205(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT205 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT205(m);
    }

    public MT205() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT205(String sender, String receiver) {
        super(205, sender, receiver);
        this.m.setUETR();
    }

    public MT205(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT205.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT205 object from FIN content with a Service Message. Check if the MT205 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT205 object from FIN content with message type " + param.getType());
        }
    }

    public static MT205 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT205(fin);
    }

    public MT205(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT205 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT205(stream);
    }

    public MT205(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT205 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT205(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    public String getUETR() {
        if (this.getSwiftMessage() == null) {
            return null;
        }
        return this.getSwiftMessage().getUETR();
    }

    @Override
    public MT205 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT205 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT205 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT205 fromJson(String json) {
        return (MT205)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field53A getField53A() {
        Tag t = this.tag("53A");
        if (t != null) {
            return new Field53A(t.getValue());
        }
        return null;
    }

    public Field53B getField53B() {
        Tag t = this.tag("53B");
        if (t != null) {
            return new Field53B(t.getValue());
        }
        return null;
    }

    public Field53D getField53D() {
        Tag t = this.tag("53D");
        if (t != null) {
            return new Field53D(t.getValue());
        }
        return null;
    }

    public Field56A getField56A() {
        Tag t = this.tag("56A");
        if (t != null) {
            return new Field56A(t.getValue());
        }
        return null;
    }

    public Field56D getField56D() {
        Tag t = this.tag("56D");
        if (t != null) {
            return new Field56D(t.getValue());
        }
        return null;
    }

    public Field57A getField57A() {
        Tag t = this.tag("57A");
        if (t != null) {
            return new Field57A(t.getValue());
        }
        return null;
    }

    public Field57B getField57B() {
        Tag t = this.tag("57B");
        if (t != null) {
            return new Field57B(t.getValue());
        }
        return null;
    }

    public Field57D getField57D() {
        Tag t = this.tag("57D");
        if (t != null) {
            return new Field57D(t.getValue());
        }
        return null;
    }

    public Field58A getField58A() {
        Tag t = this.tag("58A");
        if (t != null) {
            return new Field58A(t.getValue());
        }
        return null;
    }

    public Field58D getField58D() {
        Tag t = this.tag("58D");
        if (t != null) {
            return new Field58D(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field13C> getField13C() {
        ArrayList<Field13C> result = new ArrayList<Field13C>();
        Tag[] tags = this.tags("13C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13C(tag.getValue()));
            }
        }
        return result;
    }
}

