/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt3xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field16R;
import com.prowidesoftware.swift.model.field.Field16S;
import com.prowidesoftware.swift.model.field.Field19A;
import com.prowidesoftware.swift.model.field.Field20C;
import com.prowidesoftware.swift.model.field.Field22F;
import com.prowidesoftware.swift.model.field.Field22H;
import com.prowidesoftware.swift.model.field.Field23G;
import com.prowidesoftware.swift.model.field.Field70E;
import com.prowidesoftware.swift.model.field.Field95P;
import com.prowidesoftware.swift.model.field.Field95Q;
import com.prowidesoftware.swift.model.field.Field95R;
import com.prowidesoftware.swift.model.field.Field97A;
import com.prowidesoftware.swift.model.field.Field98A;
import com.prowidesoftware.swift.model.field.Field98C;
import com.prowidesoftware.swift.model.field.Field98E;
import com.prowidesoftware.swift.model.field.Field99A;
import com.prowidesoftware.swift.model.field.Field99C;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT370
extends AbstractMT
implements Serializable {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT370.class.getName());
    public static final String NAME = "370";

    public MT370(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT370(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT370 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT370(m);
    }

    public MT370() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT370(String sender, String receiver) {
        super(370, sender, receiver);
    }

    public MT370(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT370.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT370 object from FIN content with a Service Message. Check if the MT370 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT370 object from FIN content with message type " + param.getType());
        }
    }

    public static MT370 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT370(fin);
    }

    public MT370(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT370 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT370(stream);
    }

    public MT370(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT370 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT370(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT370 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT370 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT370 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT370 fromJson(String json) {
        return (MT370)AbstractMT.fromJson(json);
    }

    public Field23G getField23G() {
        Tag t = this.tag("23G");
        if (t != null) {
            return new Field23G(t.getValue());
        }
        return null;
    }

    public Field98E getField98E() {
        Tag t = this.tag("98E");
        if (t != null) {
            return new Field98E(t.getValue());
        }
        return null;
    }

    public Field19A getField19A() {
        Tag t = this.tag("19A");
        if (t != null) {
            return new Field19A(t.getValue());
        }
        return null;
    }

    public Field22H getField22H() {
        Tag t = this.tag("22H");
        if (t != null) {
            return new Field22H(t.getValue());
        }
        return null;
    }

    public Field99A getField99A() {
        Tag t = this.tag("99A");
        if (t != null) {
            return new Field99A(t.getValue());
        }
        return null;
    }

    public Field99C getField99C() {
        Tag t = this.tag("99C");
        if (t != null) {
            return new Field99C(t.getValue());
        }
        return null;
    }

    public List<Field16R> getField16R() {
        ArrayList<Field16R> result = new ArrayList<Field16R>();
        Tag[] tags = this.tags("16R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field20C> getField20C() {
        ArrayList<Field20C> result = new ArrayList<Field20C>();
        Tag[] tags = this.tags("20C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16S> getField16S() {
        ArrayList<Field16S> result = new ArrayList<Field16S>();
        Tag[] tags = this.tags("16S");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16S(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95P> getField95P() {
        ArrayList<Field95P> result = new ArrayList<Field95P>();
        Tag[] tags = this.tags("95P");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95P(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98A> getField98A() {
        ArrayList<Field98A> result = new ArrayList<Field98A>();
        Tag[] tags = this.tags("98A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98C> getField98C() {
        ArrayList<Field98C> result = new ArrayList<Field98C>();
        Tag[] tags = this.tags("98C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field97A> getField97A() {
        ArrayList<Field97A> result = new ArrayList<Field97A>();
        Tag[] tags = this.tags("97A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field97A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field22F> getField22F() {
        ArrayList<Field22F> result = new ArrayList<Field22F>();
        Tag[] tags = this.tags("22F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field22F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field70E> getField70E() {
        ArrayList<Field70E> result = new ArrayList<Field70E>();
        Tag[] tags = this.tags("70E");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field70E(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95Q> getField95Q() {
        ArrayList<Field95Q> result = new ArrayList<Field95Q>();
        Tag[] tags = this.tags("95Q");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95Q(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95R> getField95R() {
        ArrayList<Field95R> result = new ArrayList<Field95R>();
        Tag[] tags = this.tags("95R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95R(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return new SequenceA(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        SequenceA s = new SequenceA();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("GENL").getTags());
        }
        return s;
    }

    public List<SequenceA1> getSequenceA1List() {
        return MT370.getSequenceA1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceA1> getSequenceA1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("LINK")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceA1> result = new ArrayList<SequenceA1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceA1 s = new SequenceA1();
                s.setTags(b.getSubBlock("LINK").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public SequenceA2 getSequenceA2() {
        return new SequenceA2(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceA2 getSequenceA2(SwiftTagListBlock parentSequence) {
        SequenceA2 s = new SequenceA2();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("ORDRPRTY").getTags());
        }
        return s;
    }

    public SequenceB getSequenceB() {
        return new SequenceB(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceB getSequenceB(SwiftTagListBlock parentSequence) {
        SequenceB s = new SequenceB();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("NETPOS").getTags());
        }
        return s;
    }

    public List<SequenceB1> getSequenceB1List() {
        return MT370.getSequenceB1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceB1> getSequenceB1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("CSHPRTY")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB1> result = new ArrayList<SequenceB1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB1 s = new SequenceB1();
                s.setTags(b.getSubBlock("CSHPRTY").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceB1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "CSHPRTY";
        public static final Tag START_TAG = new Tag("16R", "CSHPRTY");
        public static final Tag END_TAG = new Tag("16S", "CSHPRTY");

        private SequenceB1() {
            super(new ArrayList<Tag>());
        }

        private SequenceB1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB1 newInstance(Tag ... tags) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance() {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "NETPOS";
        public static final Tag START_TAG = new Tag("16R", "NETPOS");
        public static final Tag END_TAG = new Tag("16S", "NETPOS");

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance() {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance(SwiftTagListBlock ... sequences) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA2
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "ORDRPRTY";
        public static final Tag START_TAG = new Tag("16R", "ORDRPRTY");
        public static final Tag END_TAG = new Tag("16S", "ORDRPRTY");

        private SequenceA2() {
            super(new ArrayList<Tag>());
        }

        private SequenceA2(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA2 newInstance(Tag ... tags) {
            SequenceA2 result = new SequenceA2();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA2 newInstance() {
            SequenceA2 result = new SequenceA2();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA2 newInstance(SwiftTagListBlock ... sequences) {
            SequenceA2 result = new SequenceA2();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA2(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LINK";
        public static final Tag START_TAG = new Tag("16R", "LINK");
        public static final Tag END_TAG = new Tag("16S", "LINK");

        private SequenceA1() {
            super(new ArrayList<Tag>());
        }

        private SequenceA1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA1 newInstance(Tag ... tags) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance() {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "GENL";
        public static final Tag START_TAG = new Tag("16R", "GENL");
        public static final Tag END_TAG = new Tag("16S", "GENL");

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }
}

