/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field26H;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field31F;
import com.prowidesoftware.swift.model.field.Field31L;
import com.prowidesoftware.swift.model.field.Field31P;
import com.prowidesoftware.swift.model.field.Field31X;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field33S;
import com.prowidesoftware.swift.model.field.Field33T;
import com.prowidesoftware.swift.model.field.Field35A;
import com.prowidesoftware.swift.model.field.Field35B;
import com.prowidesoftware.swift.model.field.Field35N;
import com.prowidesoftware.swift.model.field.Field35S;
import com.prowidesoftware.swift.model.field.Field37A;
import com.prowidesoftware.swift.model.field.Field37B;
import com.prowidesoftware.swift.model.field.Field37C;
import com.prowidesoftware.swift.model.field.Field37D;
import com.prowidesoftware.swift.model.field.Field37E;
import com.prowidesoftware.swift.model.field.Field37F;
import com.prowidesoftware.swift.model.field.Field37J;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57B;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field77D;
import com.prowidesoftware.swift.model.field.Field83C;
import com.prowidesoftware.swift.model.field.Field87A;
import com.prowidesoftware.swift.model.field.Field87D;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT516
extends AbstractMT
implements Serializable {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT516.class.getName());
    public static final String NAME = "516";

    public MT516(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT516(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT516 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT516(m);
    }

    public MT516() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT516(String sender, String receiver) {
        super(516, sender, receiver);
    }

    public MT516(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT516.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT516 object from FIN content with a Service Message. Check if the MT516 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT516 object from FIN content with message type " + param.getType());
        }
    }

    public static MT516 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT516(fin);
    }

    public MT516(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT516 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT516(stream);
    }

    public MT516(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT516 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT516(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT516 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT516 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT516 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT516 fromJson(String json) {
        return (MT516)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field23 getField23() {
        Tag t = this.tag("23");
        if (t != null) {
            return new Field23(t.getValue());
        }
        return null;
    }

    public Field31P getField31P() {
        Tag t = this.tag("31P");
        if (t != null) {
            return new Field31P(t.getValue());
        }
        return null;
    }

    public Field83C getField83C() {
        Tag t = this.tag("83C");
        if (t != null) {
            return new Field83C(t.getValue());
        }
        return null;
    }

    public Field35A getField35A() {
        Tag t = this.tag("35A");
        if (t != null) {
            return new Field35A(t.getValue());
        }
        return null;
    }

    public Field31L getField31L() {
        Tag t = this.tag("31L");
        if (t != null) {
            return new Field31L(t.getValue());
        }
        return null;
    }

    public Field31X getField31X() {
        Tag t = this.tag("31X");
        if (t != null) {
            return new Field31X(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field31F getField31F() {
        Tag t = this.tag("31F");
        if (t != null) {
            return new Field31F(t.getValue());
        }
        return null;
    }

    public Field35N getField35N() {
        Tag t = this.tag("35N");
        if (t != null) {
            return new Field35N(t.getValue());
        }
        return null;
    }

    public Field33T getField33T() {
        Tag t = this.tag("33T");
        if (t != null) {
            return new Field33T(t.getValue());
        }
        return null;
    }

    public Field37J getField37J() {
        Tag t = this.tag("37J");
        if (t != null) {
            return new Field37J(t.getValue());
        }
        return null;
    }

    public Field26H getField26H() {
        Tag t = this.tag("26H");
        if (t != null) {
            return new Field26H(t.getValue());
        }
        return null;
    }

    public Field33S getField33S() {
        Tag t = this.tag("33S");
        if (t != null) {
            return new Field33S(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field32B getField32B() {
        Tag t = this.tag("32B");
        if (t != null) {
            return new Field32B(t.getValue());
        }
        return null;
    }

    public Field37A getField37A() {
        Tag t = this.tag("37A");
        if (t != null) {
            return new Field37A(t.getValue());
        }
        return null;
    }

    public Field37B getField37B() {
        Tag t = this.tag("37B");
        if (t != null) {
            return new Field37B(t.getValue());
        }
        return null;
    }

    public Field37C getField37C() {
        Tag t = this.tag("37C");
        if (t != null) {
            return new Field37C(t.getValue());
        }
        return null;
    }

    public Field37D getField37D() {
        Tag t = this.tag("37D");
        if (t != null) {
            return new Field37D(t.getValue());
        }
        return null;
    }

    public Field37E getField37E() {
        Tag t = this.tag("37E");
        if (t != null) {
            return new Field37E(t.getValue());
        }
        return null;
    }

    public Field37F getField37F() {
        Tag t = this.tag("37F");
        if (t != null) {
            return new Field37F(t.getValue());
        }
        return null;
    }

    public Field57A getField57A() {
        Tag t = this.tag("57A");
        if (t != null) {
            return new Field57A(t.getValue());
        }
        return null;
    }

    public Field57B getField57B() {
        Tag t = this.tag("57B");
        if (t != null) {
            return new Field57B(t.getValue());
        }
        return null;
    }

    public Field57D getField57D() {
        Tag t = this.tag("57D");
        if (t != null) {
            return new Field57D(t.getValue());
        }
        return null;
    }

    public Field35S getField35S() {
        Tag t = this.tag("35S");
        if (t != null) {
            return new Field35S(t.getValue());
        }
        return null;
    }

    public Field77D getField77D() {
        Tag t = this.tag("77D");
        if (t != null) {
            return new Field77D(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field35B> getField35B() {
        ArrayList<Field35B> result = new ArrayList<Field35B>();
        Tag[] tags = this.tags("35B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field35B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field87A> getField87A() {
        ArrayList<Field87A> result = new ArrayList<Field87A>();
        Tag[] tags = this.tags("87A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field87A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field87D> getField87D() {
        ArrayList<Field87D> result = new ArrayList<Field87D>();
        Tag[] tags = this.tags("87D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field87D(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            SwiftTagListBlock content = parentSequence.getSubBlockDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (content == null) {
                    log.fine("content for sequence SequenceA: is null");
                } else {
                    log.fine("content for sequence SequenceA: " + content.tagNamesList());
                }
            }
            if (content == null) {
                return new SequenceA();
            }
            return new SequenceA(content);
        }
        return null;
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"30"};
        protected static final String[] TAIL = new String[]{"31F", "87A", "87D", "35N", "33T"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

