/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field32C;
import com.prowidesoftware.swift.model.field.Field32D;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field71B;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT990
extends AbstractMT
implements Serializable {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT990.class.getName());
    public static final String NAME = "990";

    public MT990(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT990(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT990 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT990(m);
    }

    public MT990() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT990(String sender, String receiver) {
        super(990, sender, receiver);
    }

    public MT990(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT990.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT990 object from FIN content with a Service Message. Check if the MT990 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT990 object from FIN content with message type " + param.getType());
        }
    }

    public static MT990 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT990(fin);
    }

    public MT990(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT990 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT990(stream);
    }

    public MT990(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT990 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT990(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT990 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT990 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT990 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT990 fromJson(String json) {
        return (MT990)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public Field32C getField32C() {
        Tag t = this.tag("32C");
        if (t != null) {
            return new Field32C(t.getValue());
        }
        return null;
    }

    public Field32D getField32D() {
        Tag t = this.tag("32D");
        if (t != null) {
            return new Field32D(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field71B getField71B() {
        Tag t = this.tag("71B");
        if (t != null) {
            return new Field71B(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }
}

