/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.JsonSerializable;
import com.prowidesoftware.swift.Resolver;
import com.prowidesoftware.swift.model.AbstractMessage;
import com.prowidesoftware.swift.model.MessageStandardType;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.mx.AbstractMXAdapter;
import com.prowidesoftware.swift.model.mx.BusinessHeader;
import com.prowidesoftware.swift.model.mx.IDocument;
import com.prowidesoftware.swift.model.mx.XMLGregorianCalendarAdapter;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractMX
extends AbstractMessage
implements IDocument,
JsonSerializable {
    private static final transient Logger log = Logger.getLogger(AbstractMX.class.getName());
    public static String DEFAULT_ROOT_ELEMENT = "RequestPayload";
    private BusinessHeader businessHeader;

    protected AbstractMX() {
        super(MessageStandardType.MX);
    }

    protected AbstractMX(BusinessHeader businessHeader) {
        super(MessageStandardType.MX);
        this.businessHeader = businessHeader;
    }

    protected static String message(String namespace, AbstractMX obj, Class[] classes, String prefix, boolean includeXMLDeclaration) {
        return Resolver.mxWrite().message(namespace, obj, classes, prefix, includeXMLDeclaration);
    }

    protected static AbstractMX read(Class<? extends AbstractMX> targetClass, String xml, Class[] classes) {
        return Resolver.mxRead().read(targetClass, xml, classes);
    }

    public abstract Class[] getClasses();

    public abstract String getNamespace();

    public abstract String getBusinessProcess();

    public abstract int getFunctionality();

    public abstract int getVariant();

    public abstract int getVersion();

    @Override
    public String message() {
        return this.message(null, true);
    }

    public String message(String rootElement, boolean includeXMLDeclaration) {
        String header;
        String root = rootElement != null ? rootElement : DEFAULT_ROOT_ELEMENT;
        StringBuilder xml = new StringBuilder();
        if (includeXMLDeclaration) {
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        }
        if ((header = this.header("h", false)) != null) {
            xml.append("<" + root + ">\n");
            xml.append(header + "\n");
        }
        xml.append(this.document("Doc", false) + "\n");
        if (header != null) {
            xml.append("</" + root + ">");
        }
        return xml.toString();
    }

    public String message(String rootElement) {
        return this.message(rootElement, true);
    }

    public String header() {
        return this.header(null, false);
    }

    public String header(String prefix, boolean includeXMLDeclaration) {
        if (this.businessHeader != null) {
            return this.businessHeader.xml(prefix, includeXMLDeclaration);
        }
        return null;
    }

    public String document() {
        return this.document("Doc", true);
    }

    public String document(String prefix, boolean includeXMLDeclaration) {
        return AbstractMX.message(this.getNamespace(), this, this.getClasses(), prefix, includeXMLDeclaration);
    }

    public Source xmlSource() {
        String xml = this.message();
        log.fine("XML: " + xml);
        if (xml != null) {
            return new StreamSource(new StringReader(xml));
        }
        return null;
    }

    public void write(File file) throws IOException {
        Validate.notNull((Object)file, (String)"the file to write cannot be null", (Object[])new Object[0]);
        boolean created = file.createNewFile();
        if (created) {
            log.fine("new file created: " + file.getAbsolutePath());
        }
        FileOutputStream stream = new FileOutputStream(file.getAbsoluteFile());
        this.write(stream);
        stream.close();
    }

    public void write(OutputStream stream) throws IOException {
        Validate.notNull((Object)stream, (String)"the stream to write cannot be null", (Object[])new Object[0]);
        stream.write(this.message().getBytes("UTF-8"));
    }

    @XmlTransient
    public BusinessHeader getBusinessHeader() {
        return this.businessHeader;
    }

    public void setBusinessHeader(BusinessHeader businessHeader) {
        this.businessHeader = businessHeader;
    }

    public MxId getMxId() {
        return new MxId(this.getBusinessProcess(), StringUtils.leftPad((String)Integer.toString(this.getFunctionality()), (int)3, (String)"0"), StringUtils.leftPad((String)Integer.toString(this.getVariant()), (int)3, (String)"0"), StringUtils.leftPad((String)Integer.toString(this.getVersion()), (int)2, (String)"0"));
    }

    public Element element() {
        HashMap properties = new HashMap();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])this.getClasses(), properties);
            DOMResult res = new DOMResult();
            context.createMarshaller().marshal((Object)this, (Result)res);
            Document doc = (Document)res.getNode();
            return (Element)doc.getFirstChild();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error creating XML Document for MX", e);
            return null;
        }
    }

    public static AbstractMX parse(String xml, MxId id) {
        return Resolver.mxRead().read(xml, id);
    }

    public static AbstractMX parse(File file, MxId id) throws IOException {
        return AbstractMX.parse(Lib.readFile(file), id);
    }

    @Override
    public String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbstractMX.class, (Object)new AbstractMXAdapter()).registerTypeAdapter(XMLGregorianCalendar.class, (Object)new XMLGregorianCalendarAdapter()).setPrettyPrinting().create();
        return gson.toJson((Object)this, AbstractMX.class);
    }

    protected static <T> T fromJson(String json, Class<T> classOfT) {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbstractMX.class, (Object)new AbstractMXAdapter()).registerTypeAdapter(XMLGregorianCalendar.class, (Object)new XMLGregorianCalendarAdapter()).create();
        return (T)gson.fromJson(json, classOfT);
    }

    public static AbstractMX fromJson(String json) {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbstractMX.class, (Object)new AbstractMXAdapter()).registerTypeAdapter(XMLGregorianCalendar.class, (Object)new XMLGregorianCalendarAdapter()).create();
        return (AbstractMX)gson.fromJson(json, AbstractMX.class);
    }
}

