/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import com.prowidesoftware.swift.io.AbstractReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Logger;

public class PPCReader
extends AbstractReader {
    private static final Logger log = Logger.getLogger(PPCReader.class.getName());
    static final int BEGIN = 1;
    static final int END = 3;
    static final int NULL = 0;
    static final int EMPTY = 32;
    private int curChar = 0;

    public PPCReader(Reader r) {
        super(r);
    }

    public PPCReader(String string) {
        super(string);
    }

    public PPCReader(InputStream stream) {
        super(stream);
    }

    public PPCReader(File file) throws FileNotFoundException {
        super(file);
    }

    @Override
    public boolean hasNext() {
        if (this.reader == null) {
            throw new IllegalStateException("reader is null");
        }
        while (this.curChar != -1 && this.curChar != 1) {
            try {
                this.curChar = this.reader.read();
            }
            catch (IOException e) {
                log.severe("IOException while reading: " + e);
                return false;
            }
        }
        return this.curChar == 1;
    }

    @Override
    public String next() {
        if (this.curChar == 1) {
            StringBuilder sb = new StringBuilder();
            boolean done = false;
            do {
                try {
                    this.curChar = this.reader.read();
                }
                catch (IOException e) {
                    log.severe("error reading: " + e);
                    return sb.toString();
                }
                if (this.curChar == -1 || this.curChar == 3) {
                    done = true;
                    continue;
                }
                sb.append((char)this.curChar);
            } while (!done);
            return sb.toString().trim();
        }
        throw new IllegalStateException("hasNext did not return true but this method was called");
    }
}

