/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.writer;

import com.prowidesoftware.ProwideException;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.utils.IMessageVisitor;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class FINWriterVisitor
implements IMessageVisitor {
    private static final transient Logger log = Logger.getLogger(FINWriterVisitor.class.getName());
    public static final String SWIFT_EOL = "\r\n";
    private Writer writer;
    private boolean block4asText = true;
    private boolean trimTagValues = false;

    public boolean isTrimTagValues() {
        return this.trimTagValues;
    }

    public void setTrimTagValues(boolean trimTagValues) {
        this.trimTagValues = trimTagValues;
    }

    public FINWriterVisitor(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void startMessage(SwiftMessage m) {
        String mt;
        SwiftBlock2 b2;
        SwiftBlock1 b1;
        this.block4asText = true;
        SwiftBlock1 swiftBlock1 = b1 = m != null ? m.getBlock1() : null;
        if (b1 != null && StringUtils.isNotEmpty((CharSequence)b1.getValue())) {
            boolean isAppIdOrServiceId;
            boolean bl = isAppIdOrServiceId = !StringUtils.equals((CharSequence)b1.getApplicationId(), (CharSequence)"F") || !StringUtils.equals((CharSequence)b1.getServiceId(), (CharSequence)"01");
            if (isAppIdOrServiceId) {
                this.block4asText = false;
            }
        }
        SwiftBlock2 swiftBlock2 = b2 = m != null ? m.getBlock2() : null;
        if (b2 != null && StringUtils.isNotEmpty((CharSequence)b2.getValue()) && (mt = StringUtils.trimToEmpty((String)b2.getMessageType())).startsWith("0")) {
            this.block4asText = false;
        }
    }

    @Override
    public void endMessage(SwiftMessage m) {
        if (m.getUnparsedTextsSize() > 0) {
            this.write(m.getUnparsedTexts());
        }
        this.block4asText = true;
    }

    @Override
    public void startBlock1(SwiftBlock1 b) {
        this.write("{1:");
    }

    @Override
    public void value(SwiftBlock1 b, String v) {
        if (StringUtils.isNotEmpty((CharSequence)v)) {
            this.write(v);
        }
    }

    @Override
    public void endBlock1(SwiftBlock1 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write("}");
    }

    @Override
    public void startBlock2(SwiftBlock2 b) {
        this.write("{2:");
    }

    @Override
    public void value(SwiftBlock2 b, String v) {
        if (StringUtils.isNotEmpty((CharSequence)v)) {
            this.write(v);
        }
    }

    @Override
    public void endBlock2(SwiftBlock2 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write("}");
    }

    @Override
    public void startBlock3(SwiftBlock3 b) {
        this.write("{3:");
    }

    @Override
    public void tag(SwiftBlock3 b, Tag t) {
        this.appendBlockTag(t);
    }

    @Override
    public void endBlock3(SwiftBlock3 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write("}");
    }

    @Override
    public void startBlock4(SwiftBlock4 b) {
        this.write("{4:" + (this.block4asText ? SWIFT_EOL : ""));
    }

    @Override
    public void tag(SwiftBlock4 b, Tag t) {
        if (this.block4asText) {
            this.appendTextTag(t);
        } else {
            this.appendBlockTag(t);
        }
    }

    @Override
    public void endBlock4(SwiftBlock4 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write((this.block4asText ? "-" : "") + "}");
    }

    @Override
    public void startBlock5(SwiftBlock5 b) {
        this.write("{5:");
    }

    @Override
    public void tag(SwiftBlock5 b, Tag t) {
        this.appendBlockTag(t);
    }

    @Override
    public void endBlock5(SwiftBlock5 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write("}");
    }

    @Override
    public void startBlockUser(SwiftBlockUser b) {
        this.write("{" + b.getName() + ":");
    }

    @Override
    public void tag(SwiftBlockUser b, Tag t) {
        this.appendBlockTag(t);
    }

    @Override
    public void endBlockUser(SwiftBlockUser b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts());
        }
        this.write("}");
    }

    public void tag(SwiftBlock b, Tag t) {
        if (b == null) {
            return;
        }
        if (b instanceof SwiftBlock3) {
            this.tag((SwiftBlock3)b, t);
        }
        if (b instanceof SwiftBlock4) {
            this.tag((SwiftBlock4)b, t);
        }
        if (b instanceof SwiftBlock5) {
            this.tag((SwiftBlock5)b, t);
        }
        if (b instanceof SwiftBlockUser) {
            this.tag((SwiftBlockUser)b, t);
        }
    }

    private void appendBlockTag(Tag t) {
        if (StringUtils.isEmpty((CharSequence)t.getName()) && StringUtils.isEmpty((CharSequence)t.getValue())) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)t.getName())) {
            this.write("{" + t.getName() + ":" + this.notNullValue(t));
        } else {
            this.write("{" + this.notNullValue(t));
        }
        if (t.getUnparsedTextsSize() > 0) {
            this.write(t.getUnparsedTexts());
        }
        this.write("}");
    }

    private String notNullValue(Tag t) {
        if (this.trimTagValues) {
            return StringUtils.trimToEmpty((String)t.getValue());
        }
        if (t.getValue() == null) {
            return "";
        }
        return t.getValue();
    }

    private void appendTextTag(Tag t) {
        if (StringUtils.isNotEmpty((CharSequence)t.getName())) {
            this.write(":" + t.getName() + ":" + this.notNullValue(t) + SWIFT_EOL);
        }
        if (t.getUnparsedTextsSize() > 0) {
            this.write(t.getUnparsedTexts());
        }
    }

    protected String getTagValue(Tag t, int block) {
        String s = t.getValue();
        if (t.getName() == null && s.startsWith(block + ":") && s.length() > 2) {
            return s.substring(2);
        }
        return s;
    }

    private void write(UnparsedTextList texts) {
        if (texts.size() > 0) {
            for (int i = 0; i < texts.size(); ++i) {
                if (!texts.isMessage(i).booleanValue()) continue;
                this.write(texts.getText(i));
            }
        }
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Caught exception in FINWriterVisitor, method write", e);
            throw new ProwideException(e);
        }
    }
}

