/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.BicValidationResult;
import com.prowidesoftware.swift.utils.IsoUtils;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class BIC {
    public static final transient String TEST8 = "TESTARZZ";
    public static final transient String TEST12 = "TESTARZZAXXX";
    public static final String PARTNER_PREFIX = "PTS";
    @Deprecated
    private String invalidCause = null;
    private String institution = null;
    private String country = null;
    private String location = null;
    protected String branch = null;
    private String subtype = null;

    public BIC(String bic) {
        this.parse(bic);
    }

    protected void parse(String bic) {
        if (bic != null) {
            this.institution = StringUtils.trimToNull((String)StringUtils.substring((String)bic, (int)0, (int)4));
            this.country = StringUtils.trimToNull((String)StringUtils.substring((String)bic, (int)4, (int)6));
            this.location = StringUtils.trimToNull((String)StringUtils.substring((String)bic, (int)6, (int)8));
            this.branch = bic.length() >= 12 ? StringUtils.trimToNull((String)StringUtils.substring((String)bic, (int)9)) : StringUtils.trimToNull((String)StringUtils.substring((String)bic, (int)8));
        }
    }

    public BIC() {
    }

    @Deprecated
    public String getInvalidCause() {
        DeprecationUtils.phase3(this.getClass(), "getInvalidCause()", "Use the validate() method to get a detailed result of the validation problem found");
        return this.invalidCause;
    }

    public boolean isValid() {
        BicValidationResult result = this.validate();
        if (result == BicValidationResult.OK) {
            return true;
        }
        this.invalidCause = result.message();
        return false;
    }

    public BicValidationResult validate() {
        if (this.institution == null || this.country == null || this.location == null) {
            return BicValidationResult.INVALID_LENGTH;
        }
        if (this.institution.length() != 4) {
            BicValidationResult result = BicValidationResult.INVALID_INSTITUTION_LENGTH;
            result.setFound(this.institution);
            return result;
        }
        if (this.country.length() != 2) {
            BicValidationResult result = BicValidationResult.INVALID_COUNTRY_LENGTH;
            result.setFound(this.country);
            return result;
        }
        if (this.location.length() != 2) {
            BicValidationResult result = BicValidationResult.INVALID_LOCATION_LENGTH;
            result.setFound(this.location);
            return result;
        }
        if (this.branch != null && this.branch.length() != 3) {
            BicValidationResult result = BicValidationResult.INVALID_BRANCH_LENGTH;
            result.setFound(this.branch);
            return result;
        }
        if (!this.isUpperCase(this.institution)) {
            BicValidationResult result = BicValidationResult.INVALID_INSTITUTION_CHARSET;
            result.setFound(this.institution);
            return result;
        }
        if (!IsoUtils.getInstance().isValidISOCountry(this.country)) {
            BicValidationResult result = BicValidationResult.INVALID_COUNTRY;
            result.setFound(this.country);
            return result;
        }
        if (!this.isUpperCaseOrDigit(this.location)) {
            BicValidationResult result = BicValidationResult.INVALID_LOCATION_CHARSET;
            result.setFound(this.location);
            return result;
        }
        if (this.branch != null && !this.isUpperCaseOrDigit(this.branch)) {
            BicValidationResult result = BicValidationResult.INVALID_BRANCH_CHARSET;
            result.setFound(this.branch);
            return result;
        }
        return BicValidationResult.OK;
    }

    private boolean isUpperCase(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isUpperCaseOrDigit(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i)) || Character.isDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBranchOrDefault() {
        return this.branch != null ? this.branch : "XXX";
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public boolean isTestAndTraining() {
        if (this.location != null) {
            return this.location.charAt(1) == '0';
        }
        return false;
    }

    public boolean isNonLive() {
        if (this.location != null) {
            return this.location.charAt(1) == '1';
        }
        return false;
    }

    public boolean isLive() {
        if (this.location != null) {
            return this.location.charAt(1) != '0' && this.location.charAt(1) != '1';
        }
        return false;
    }

    public String getBic8() {
        if (this.institution != null && this.country != null && this.location != null) {
            return this.institution + this.country + this.location;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BIC bic = (BIC)o;
        return Objects.equals(this.institution, bic.institution) && Objects.equals(this.country, bic.country) && Objects.equals(this.location, bic.location) && Objects.equals(this.branch, bic.branch) && Objects.equals(this.subtype, bic.subtype);
    }

    public int hashCode() {
        return Objects.hash(this.institution, this.country, this.location, this.branch, this.subtype);
    }

    public String getBic11() {
        String bic8 = this.getBic8();
        if (bic8 != null) {
            return bic8 + this.getBranchOrDefault();
        }
        return null;
    }

    @Deprecated
    public String country() {
        DeprecationUtils.phase3(this.getClass(), "country()", "use getCountry() instead");
        return this.getCountry();
    }

    @Deprecated
    public String institution() {
        DeprecationUtils.phase3(this.getClass(), "institution()", "use getInstitution() instead");
        return this.getInstitution();
    }

    public String distinguishedName() {
        StringBuilder result = new StringBuilder();
        if (this.branch != null && !this.branch.equals("XXX")) {
            result.append("ou=").append(StringUtils.lowerCase((String)this.branch)).append(",");
        }
        result.append("o=").append(StringUtils.lowerCase((String)this.getBic8())).append(",o=swift");
        return result.toString();
    }

    public String toString() {
        return this.getBic11();
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public BIC asTestBic() {
        BIC bic = new BIC(this.getBic11());
        if (bic.getLocation() == null || bic.getLocation().isEmpty()) {
            bic.setLocation("00");
        } else {
            bic.setLocation(bic.getLocation().charAt(0) + "0");
        }
        return bic;
    }
}

