/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class Money
implements Serializable {
    private static final long serialVersionUID = -7552352742105490377L;
    private static final transient Logger log = Logger.getLogger(Money.class.getName());
    private final String currency;
    private final BigDecimal amount;

    public Money(Currency currency, BigDecimal amount) {
        this(currency.getCurrencyCode(), amount);
    }

    public Money(String currency, BigDecimal amount) {
        Validate.notNull((Object)currency, (String)"currency can not be null", (Object[])new Object[0]);
        this.currency = currency;
        this.amount = amount == null ? BigDecimal.ZERO : amount;
    }

    public Money(Currency currency, Number amount) {
        this(currency.getCurrencyCode(), amount);
    }

    public Money(String currency, Number amount) {
        this.currency = currency;
        if (amount == null) {
            this.amount = BigDecimal.ZERO;
        } else if (amount instanceof BigDecimal) {
            this.amount = (BigDecimal)amount;
        } else if (amount instanceof Long) {
            this.amount = new BigDecimal((Long)amount);
        } else if (amount instanceof Integer) {
            this.amount = new BigDecimal((Integer)amount);
        } else if (amount instanceof Short) {
            this.amount = new BigDecimal(((Short)amount).intValue());
        } else if (amount instanceof Double) {
            this.amount = BigDecimal.valueOf((Double)amount);
        } else {
            throw new IllegalArgumentException("class " + amount.getClass().getName() + " is not supported");
        }
    }

    public String getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    static Money of(Field field) {
        if (field != null && field instanceof AmountContainer) {
            BigDecimal amount = ((AmountContainer)((Object)field)).amount();
            if (amount == null) {
                log.warning("cannot extract amount component from field " + field.getName() + ":" + field.getValue());
                return null;
            }
            String currency = null;
            boolean negative = false;
            if ("62F".equals(field.getName()) || "62M".equals(field.getName())) {
                currency = field.getComponent(3);
                negative = StringUtils.equals((CharSequence)"D", (CharSequence)field.getComponent(1));
            } else if ("19A".equals(field.getName())) {
                negative = StringUtils.equals((CharSequence)"N", (CharSequence)field.getComponent(2));
            } else if ("33B".equals(field.getName())) {
                currency = field.getComponent(1);
            }
            if (currency == null && field instanceof CurrencyContainer) {
                currency = ((CurrencyContainer)((Object)field)).currencyString();
            }
            if (currency == null) {
                log.warning("cannot extract currency component from field " + field.getName() + ":" + field.getValue());
                return null;
            }
            if (negative) {
                amount = amount.negate();
            }
            return new Money(currency, amount);
        }
        return null;
    }

    static Money ofAny(SwiftTagListBlock block, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            Field field = block.getFieldByName(fieldName);
            if (field == null) continue;
            return Money.of(field);
        }
        return null;
    }

    static Money ofSum(Field ... fields) {
        if (fields == null || fields.length == 0) {
            return null;
        }
        BigDecimal total = null;
        String currency = null;
        for (Field field : fields) {
            Money money = Money.of(field);
            if (money == null) {
                return null;
            }
            if (total == null) {
                total = money.getAmount();
                currency = money.getCurrency();
                continue;
            }
            if (StringUtils.equals(currency, (CharSequence)money.getCurrency())) {
                total = total.add(money.getAmount());
                continue;
            }
            log.warning("cannot sum amounts with different currencies, expected " + currency + " and found " + money.getCurrency() + " in field " + field.getName() + ":" + field.getValue());
            return null;
        }
        if (total != null && currency != null) {
            return new Money(currency, total);
        }
        return null;
    }
}

