/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.TagVisitor;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field16R;
import com.prowidesoftware.swift.model.field.Field16S;
import com.prowidesoftware.swift.model.field.GenericField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SwiftTagListBlock
extends SwiftBlock
implements Serializable,
Iterable<Tag> {
    private static final long serialVersionUID = -3753513588165638610L;
    private static final transient Logger log = Logger.getLogger(SwiftTagListBlock.class.getName());
    private static final String TAG_VALIDATION_MESSAGE = "parameter 'tag' cannot not be null";
    private static final String NAME_VALIDATION_MESSAGE = "parameter 'name' cannot not be null";
    public static final SwiftTagListBlock EMPTY_LIST = SwiftTagListBlock.emptyList();
    private List<Tag> tags = new ArrayList<Tag>();

    public SwiftTagListBlock() {
    }

    public SwiftTagListBlock(List<Tag> tags) {
        this();
        this.tags = tags;
    }

    private static SwiftTagListBlock emptyList() {
        List<Tag> tagList = Collections.emptyList();
        return new SwiftTagListBlock(tagList);
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Tag getTagByName(String name) {
        Validate.notNull((Object)name, (String)NAME_VALIDATION_MESSAGE, (Object[])new Object[0]);
        for (Tag tag : this.tags) {
            if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)name)) continue;
            return tag;
        }
        return null;
    }

    public Tag getTag(int index) {
        return this.tags.get(index);
    }

    public boolean containsTag(String name) {
        return this.getTagByName(name) != null;
    }

    public boolean containsTag(int tagNumber) {
        return this.getTagByNumber(tagNumber) != null;
    }

    public String getTagValue(String name) {
        Tag tag = this.getTagByName(name);
        return tag != null ? tag.getValue() : null;
    }

    public Tag[] getTagsByName(String name) {
        Validate.notNull((Object)name, (String)NAME_VALIDATION_MESSAGE, (Object[])new Object[0]);
        ArrayList<Tag> l = new ArrayList<Tag>();
        for (Tag tag : this.tags) {
            if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)name)) continue;
            l.add(tag);
        }
        return l.toArray(new Tag[l.size()]);
    }

    public Tag getTagByName(String name, String component1, String component2) {
        for (Tag tag : this.getTagsByName(name)) {
            Field f = tag.asField();
            if (f == null || !f.is(component1) || !StringUtils.equals((CharSequence)f.getComponent(2), (CharSequence)component2)) continue;
            return tag;
        }
        return null;
    }

    public Tag getTagByNumber(int tagNumber) {
        for (Tag tag : this.tags) {
            if (!tag.isNumber(tagNumber)) continue;
            return tag;
        }
        return null;
    }

    public List<Tag> getTagsByNumber(int tagNumber) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag tag : this.tags) {
            if (!tag.isNumber(tagNumber)) continue;
            result.add(tag);
        }
        return result;
    }

    public List<Tag> getTagsByValue(String value) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag tag : this.tags) {
            if (!StringUtils.equals((CharSequence)tag.getValue(), (CharSequence)value)) continue;
            result.add(tag);
        }
        return result;
    }

    public List<Tag> getTagsByContent(String content) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag tag : this.tags) {
            if (!StringUtils.contains((CharSequence)tag.getValue(), (CharSequence)content)) continue;
            result.add(tag);
        }
        return result;
    }

    public String[] getTagValues(String name) {
        Validate.notNull((Object)name, (String)NAME_VALIDATION_MESSAGE, (Object[])new Object[0]);
        ArrayList<String> result = new ArrayList<String>();
        for (Tag tag : this.getTagsByName(name)) {
            result.add(tag.getValue());
        }
        return result.toArray(new String[result.size()]);
    }

    public Map<String, String> getTagMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.tags.size());
        for (Tag tag : this.tags) {
            if (map.containsKey(tag.getName())) continue;
            map.put(tag.getName(), tag.getValue());
        }
        return map;
    }

    public Field getFieldByName(String name) {
        return this.getFieldByName(name, null);
    }

    public Field[] getFieldsByName(String name) {
        List<? extends Field> fields = this.getFieldsByName(name, null);
        return fields.toArray(new Field[fields.size()]);
    }

    public Field getFieldByName(String name, String componentValue) {
        Validate.notNull((Object)name, (String)NAME_VALIDATION_MESSAGE, (Object[])new Object[0]);
        boolean wildcard = name.endsWith("a");
        for (Tag tag : this.tags) {
            if (!this.matchesName(wildcard, tag.getName(), name)) continue;
            Field field = tag.asField();
            if (field == null) {
                log.warning("Could not create field instance of " + tag);
                continue;
            }
            if (componentValue != null && !field.is(componentValue)) continue;
            return field;
        }
        return null;
    }

    public List<? extends Field> getFieldsByName(String name, String componentValue) {
        Validate.notNull((Object)name, (String)NAME_VALIDATION_MESSAGE, (Object[])new Object[0]);
        boolean wildcard = name.endsWith("a");
        ArrayList<Field> l = new ArrayList<Field>();
        for (Tag tag : this.tags) {
            if (!this.matchesName(wildcard, tag.getName(), name)) continue;
            Field field = tag.asField();
            if (field == null) {
                log.warning("Could not create field instance of " + tag);
                continue;
            }
            if (componentValue != null && !field.is(componentValue)) continue;
            l.add(field);
        }
        return l;
    }

    public List<Tag> getTagsByName(String name, String componentValue) {
        Validate.notNull((Object)name, (String)NAME_VALIDATION_MESSAGE, (Object[])new Object[0]);
        boolean wildcard = name.endsWith("a");
        ArrayList<Tag> l = new ArrayList<Tag>();
        for (Tag tag : this.tags) {
            if (!this.matchesName(wildcard, tag.getName(), name)) continue;
            if (componentValue == null) {
                l.add(tag);
                continue;
            }
            Field field = tag.asField();
            if (field == null || !field.is(componentValue)) continue;
            l.add(tag);
        }
        return l;
    }

    private boolean matchesName(boolean wildcard, String found, String expected) {
        if (wildcard) {
            return StringUtils.startsWith((CharSequence)found, (CharSequence)expected.substring(0, expected.length() - 1));
        }
        return StringUtils.equals((CharSequence)found, (CharSequence)expected);
    }

    public Field getField(int index) {
        Tag tag = this.getTag(index);
        if (tag != null) {
            return tag.asField();
        }
        return null;
    }

    public Field getFieldByName(String name, String component1, String component2) {
        for (Field field : this.getFieldsByName(name, component1)) {
            if (!StringUtils.equals((CharSequence)field.getComponent(2), (CharSequence)component2)) continue;
            return field;
        }
        return null;
    }

    public Field getFieldByQualifiers(String name, String qualifier, String conditionalQualifier) {
        for (Field field : this.getFieldsByName(name, qualifier)) {
            if (!(field instanceof GenericField) || !StringUtils.equals((CharSequence)((GenericField)((Object)field)).getConditionalQualifier(), (CharSequence)conditionalQualifier)) continue;
            return field;
        }
        return null;
    }

    public Field getFieldByNumber(int fieldNumber) {
        Tag t = this.getTagByNumber(fieldNumber);
        if (t != null) {
            return t.asField();
        }
        return null;
    }

    public List<? extends Field> getFieldsByNumber(int fieldNumber) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Tag tag : this.getTagsByNumber(fieldNumber)) {
            Field f = tag.asField();
            if (f == null) {
                throw new IllegalArgumentException("Unable to create field for tagname " + tag.getName());
            }
            result.add(f);
        }
        return result;
    }

    public Field getFieldByNumber(int fieldNumber, String componentValue) {
        for (Field field : this.getFieldsByNumber(fieldNumber)) {
            if (!field.is(componentValue)) continue;
            return field;
        }
        return null;
    }

    public boolean containsField(String name) {
        Field[] arr = this.getFieldsByName(name);
        return arr != null && arr.length > 0;
    }

    public int countByName(String name) {
        Validate.notNull((Object)name, (String)NAME_VALIDATION_MESSAGE, (Object[])new Object[0]);
        int count = 0;
        for (Tag tag : this.tags) {
            if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)name)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + (this.tags == null ? "tags=null" : this.tags.toString()) + "]";
    }

    public String removeTag(String name) {
        Validate.notNull((Object)name, (String)NAME_VALIDATION_MESSAGE, (Object[])new Object[0]);
        int i = 0;
        for (Tag t : this.tags) {
            if (StringUtils.equals((CharSequence)t.getName(), (CharSequence)name)) {
                Tag r = this.tags.remove(i);
                return r.getValue();
            }
            ++i;
        }
        return null;
    }

    public int removeAll(String name) {
        Validate.notNull((Object)name, (String)NAME_VALIDATION_MESSAGE, (Object[])new Object[0]);
        int removed = 0;
        for (Tag t : this.getTagsByName(name)) {
            this.tags.remove(t);
            ++removed;
        }
        return removed;
    }

    public Iterator<Tag> tagIterator() {
        if (this.tags == null || this.tags.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No tags in block, returning empty iterator");
            }
            return new EmptyItr();
        }
        return this.tags.iterator();
    }

    public void addTags(List<Tag> tags) {
        Validate.notNull(tags, (String)"parameter 'tags' cannot not be null", (Object[])new Object[0]);
        this.thisTagsNotNull().addAll(tags);
    }

    public void addTag(int index, Tag tag) {
        Validate.notNull((Object)tag, (String)TAG_VALIDATION_MESSAGE, (Object[])new Object[0]);
        this.thisTagsNotNull().add(index, tag);
    }

    private List<Tag> thisTagsNotNull() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public int countAll() {
        return this.tags == null ? 0 : this.tags.size();
    }

    public Tag setTag(int index, Tag tag) {
        Validate.notNull((Object)tag, (String)TAG_VALIDATION_MESSAGE, (Object[])new Object[0]);
        return this.tags.set(index, tag);
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public void setTags(Tag[] tags) {
        ArrayList<Tag> list = new ArrayList<Tag>();
        list.addAll(Arrays.asList(tags));
        this.setTags(list);
    }

    public boolean isEmpty() {
        return this.tags == null || this.tags.isEmpty();
    }

    public int size() {
        return this.tags == null ? 0 : this.tags.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SwiftTagListBlock tags1 = (SwiftTagListBlock)o;
        return Objects.equals(this.tags, tags1.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tags);
    }

    public List<SwiftTagListBlock> getSubBlocks(Tag start, Tag end) {
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        SwiftTagListBlock toAdd = null;
        boolean blockFound = false;
        for (Tag t : this.tags) {
            if (blockFound) {
                toAdd.append(t);
                if (end == null || !end.equalsIgnoreCR(t)) continue;
                result.add(toAdd);
                blockFound = false;
                toAdd = null;
                continue;
            }
            if (!start.equalsIgnoreCR(t)) continue;
            toAdd = new SwiftTagListBlock();
            toAdd.append(t);
            blockFound = true;
        }
        if (toAdd != null) {
            result.add(toAdd);
        }
        return result;
    }

    public List<SwiftTagListBlock> getSubBlocks(String blockName) {
        return this.getSubBlocks(new Tag("16R", blockName), new Tag("16S", blockName));
    }

    public List<SwiftTagListBlock> getSubBlocks(String startTagName, String endTagName) {
        Tag start = new Tag(startTagName, "");
        Tag end = new Tag(endTagName, "");
        return this._getSubBlocks(start.getNumber(), start.getLetterOption(), end.getNumber(), end.getLetterOption());
    }

    public List<SwiftTagListBlock> getSubBlocks(int startTagNumber, int endTagNumber) {
        return this._getSubBlocks(startTagNumber, null, endTagNumber, null);
    }

    public List<SwiftTagListBlock> getSubBlocks(String startTagName, int endTagNumber) {
        Tag start = new Tag(startTagName, "");
        return this._getSubBlocks(start.getNumber(), start.getLetterOption(), endTagNumber, null);
    }

    public List<SwiftTagListBlock> getSubBlocks(int startTagNumber, String endTagName) {
        Tag end = new Tag(endTagName, "");
        return this._getSubBlocks(startTagNumber, null, end.getNumber(), end.getLetterOption());
    }

    private List<SwiftTagListBlock> _getSubBlocks(int startTagNumber, String startTagLetter, int endTagNumber, String endTagLetter) {
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        SwiftTagListBlock toAdd = null;
        boolean blockFound = false;
        for (Tag t : this.tags) {
            if (blockFound) {
                toAdd.append(t);
                if ((endTagLetter == null || !StringUtils.equals((CharSequence)t.getName(), (CharSequence)(endTagNumber + endTagLetter))) && (endTagLetter != null || !t.isNumber(endTagNumber))) continue;
                result.add(toAdd);
                blockFound = false;
                toAdd = null;
                continue;
            }
            if ((startTagLetter == null || !StringUtils.equals((CharSequence)t.getName(), (CharSequence)(startTagNumber + startTagLetter))) && (startTagLetter != null || !t.isNumber(startTagNumber))) continue;
            toAdd = new SwiftTagListBlock();
            toAdd.append(t);
            blockFound = true;
        }
        if (toAdd != null) {
            result.add(toAdd);
        }
        return result;
    }

    public SwiftTagListBlock getSubBlock(String startTagName, String endTagName) {
        List<SwiftTagListBlock> l = this.getSubBlocks(startTagName, endTagName);
        if (l.isEmpty()) {
            return new SwiftTagListBlock();
        }
        return l.get(0);
    }

    public SwiftTagListBlock getSubBlock(String blockName) {
        return this.getSubBlock(new Tag("16R", blockName), new Tag("16S", blockName));
    }

    public SwiftTagListBlock getSubBlock(Tag start, Tag end) {
        List<SwiftTagListBlock> l = this.getSubBlocks(start, end);
        if (l.isEmpty()) {
            return new SwiftTagListBlock();
        }
        return l.get(0);
    }

    public SwiftTagListBlock getSubBlock(Integer from, Integer to) {
        int t;
        int f = from == null ? 0 : from;
        int n = t = to == null || to > this.tags.size() - 1 ? this.tags.size() : to.intValue();
        if (f > t) {
            throw new IllegalArgumentException("from index (" + f + ") cannot be bigger than to index (" + t + ")");
        }
        SwiftTagListBlock result = new SwiftTagListBlock();
        result.addTags(this.tags.subList(f, t));
        return result;
    }

    @Deprecated
    public SwiftTagListBlock getSubBlockByIndex(Integer startIndex, Integer endIndex) {
        DeprecationUtils.phase3(this.getClass(), "getSubBlockByIndex(Integer, Integer", "use getSubBlock(Integer, Integer) instead");
        return this.getSubBlock(startIndex, endIndex);
    }

    public SwiftTagListBlock sublist(Integer start, Integer end) {
        if (this.tags == null || this.tags.isEmpty()) {
            throw new IllegalStateException("No tags in this list");
        }
        if (start != null && start < 0 || end != null && end + 1 > this.tags.size() || start != null && end != null && start > end) {
            throw new IllegalArgumentException("start: " + start + ", end: " + end + ", size=" + this.tags.size());
        }
        SwiftTagListBlock result = new SwiftTagListBlock();
        int s = start == null ? 0 : start;
        int e = end == null ? this.tags.size() - 1 : end;
        for (int i = s; i <= e; ++i) {
            result.append(this.tags.get(i));
        }
        return result;
    }

    private SwiftTagListBlock _searchSubBlockByCriteria(Tag tag, boolean includeDelimiterInResult, SearchSelection searchSelection, SearchBoundary searchBoundary) {
        SwiftTagListBlock result = new SwiftTagListBlock();
        int index = this.getIndexByCriteria(searchBoundary, tag);
        if (index >= 0) {
            if (includeDelimiterInResult) {
                result = searchSelection == SearchSelection.AFTER ? this.getSubBlock(index, null) : this.getSubBlock(null, index + 1);
            } else {
                boolean hasDelimiterCriteria;
                boolean bl = hasDelimiterCriteria = searchSelection == SearchSelection.AFTER && index < this.tags.size() - 1 || searchSelection == SearchSelection.BEFORE && index < this.tags.size();
                if (hasDelimiterCriteria) {
                    if (searchSelection == SearchSelection.AFTER) {
                        result = this.getSubBlock(index + 1, null);
                    } else if (index != 0) {
                        result = this.getSubBlock(null, index);
                    }
                }
            }
        } else if (searchSelection == SearchSelection.BEFORE) {
            result.addTags(this.tags);
        }
        return result;
    }

    private int getIndexByCriteria(SearchBoundary criteria, Tag tag) {
        switch (criteria) {
            case FIRST_TAG_NAME: {
                return this.indexOfFirst(tag.name);
            }
            case FIRST_TAG_IGNORE_CR: {
                return this.indexOfFirstIgnoreCR(tag);
            }
            case LAST_TAG_NAME: {
                return this.indexOfLast(tag.name);
            }
        }
        return -1;
    }

    public SwiftTagListBlock getSubBlockAfterFirst(String tagname, boolean includeBoundaryInResult) {
        Tag tag = new Tag(tagname, "");
        return this._searchSubBlockByCriteria(tag, includeBoundaryInResult, SearchSelection.AFTER, SearchBoundary.FIRST_TAG_NAME);
    }

    public SwiftTagListBlock getSubBlockAfterFirst(Tag tag, boolean includeBoundaryInResult) {
        return this._searchSubBlockByCriteria(tag, includeBoundaryInResult, SearchSelection.AFTER, SearchBoundary.FIRST_TAG_IGNORE_CR);
    }

    public SwiftTagListBlock getSubBlockAfterLast(String tagname, boolean includeBoundaryInResult) {
        Tag tag = new Tag(tagname, "");
        return this._searchSubBlockByCriteria(tag, includeBoundaryInResult, SearchSelection.AFTER, SearchBoundary.LAST_TAG_NAME);
    }

    public SwiftTagListBlock getSubBlockBeforeFirst(String tagname, boolean includeBoundaryInResult) {
        Tag tag = new Tag(tagname, "");
        return this._searchSubBlockByCriteria(tag, includeBoundaryInResult, SearchSelection.BEFORE, SearchBoundary.FIRST_TAG_NAME);
    }

    public SwiftTagListBlock getSubBlockBeforeLast(String tagname, boolean includeBoundaryInResult) {
        Tag tag = new Tag(tagname, "");
        return this._searchSubBlockByCriteria(tag, includeBoundaryInResult, SearchSelection.BEFORE, SearchBoundary.LAST_TAG_NAME);
    }

    public Integer getTagIndex(String startTagNumber, String[] letterOptions) {
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag t = this.tags.get(i);
            if (!StringUtils.startsWith((CharSequence)t.getName(), (CharSequence)startTagNumber)) continue;
            if (letterOptions == null || letterOptions.length < 1) {
                return i;
            }
            for (String l : letterOptions) {
                if (!StringUtils.equals((CharSequence)t.getName(), (CharSequence)(startTagNumber + l))) continue;
                return i;
            }
        }
        return null;
    }

    public boolean containsTag(Tag t) {
        if (this.tags == null || this.tags.isEmpty()) {
            return false;
        }
        for (Tag tag : this.tags) {
            if (!tag.equals(t)) continue;
            return true;
        }
        return false;
    }

    public List<SwiftTagListBlock> splitByTagName(String tagName) {
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        if (this.tags.isEmpty() || !this.containsTag(tagName)) {
            result.add(this);
        } else {
            SwiftTagListBlock b = new SwiftTagListBlock();
            b.append(this.tags.get(0));
            for (int i = 1; i < this.tags.size(); ++i) {
                Tag t = this.tags.get(i);
                if (StringUtils.equals((CharSequence)tagName, (CharSequence)t.getName())) {
                    result.add(b);
                    b = new SwiftTagListBlock();
                }
                b.append(t);
            }
            if (!result.contains(b)) {
                result.add(b);
            }
        }
        return result;
    }

    public int indexOfLast(String tagname) {
        int result = -1;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                if (!StringUtils.equals((CharSequence)tagname, (CharSequence)this.tags.get(i).getName())) continue;
                result = i;
            }
        }
        return result;
    }

    public int indexOfLastValue(String tagname, String value) {
        int result = -1;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                if (!StringUtils.equals((CharSequence)tagname, (CharSequence)this.tags.get(i).getName()) || !StringUtils.equals((CharSequence)value, (CharSequence)this.tags.get(i).getValue())) continue;
                result = i;
            }
        }
        return result;
    }

    public int indexOfAnyLast(String ... tagnames) {
        int result = -1;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                for (String tn : tagnames) {
                    if (!StringUtils.equals((CharSequence)tn, (CharSequence)this.tags.get(i).getName())) continue;
                    result = i;
                }
            }
        }
        return result;
    }

    public int indexOfAnyLastAfterIndex(int index, String ... tagnames) {
        int result = -1;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = index; i < this.tags.size(); ++i) {
                for (String tn : tagnames) {
                    if (!StringUtils.equals((CharSequence)tn, (CharSequence)this.tags.get(i).getName())) continue;
                    result = i;
                }
            }
        }
        return result;
    }

    private int indexOfFirstIgnoreCR(Tag tag) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                if (!this.tags.get(i).equalsIgnoreCR(tag)) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfFirst(String tagname) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                if (!StringUtils.equals((CharSequence)tagname, (CharSequence)this.tags.get(i).getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfFirstValue(String tagname, String value) {
        return this.indexOfFirstValue(tagname, value, false);
    }

    private int indexOfFirstValue(String tagname, String value, boolean ignoreCR) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                Tag t = this.tags.get(i);
                if ((!ignoreCR || !t.equalsIgnoreCR(new Tag(tagname, value))) && (ignoreCR || !StringUtils.equals((CharSequence)tagname, (CharSequence)t.getName()) || !StringUtils.equals((CharSequence)value, (CharSequence)t.getValue()))) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfAnyFirst(String ... tagnames) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                for (String tn : tagnames) {
                    if (!StringUtils.equals((CharSequence)tn, (CharSequence)this.tags.get(i).getName())) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public int indexOfAnyFirstAfterIndex(int index, String ... tagnames) {
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = index; i < this.tags.size(); ++i) {
                for (String tn : tagnames) {
                    if (!StringUtils.equals((CharSequence)tn, (CharSequence)this.tags.get(i).getName())) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    @Deprecated
    public SwiftTagListBlock trimAfterFirst(String tagname, boolean includeBoundaryInResult) {
        DeprecationUtils.phase3(this.getClass(), "trimAfterFirst(String, boolean)", "use getSubBlockBeforeFirst(String, boolean) instead");
        return this.getSubBlockBeforeFirst(tagname, includeBoundaryInResult);
    }

    public SwiftTagListBlock removeSubBlock(String blockName) {
        return this.removeSubBlock(blockName, false);
    }

    public SwiftTagListBlock removeSubBlocks(String blockName) {
        return this.removeSubBlock(blockName, true);
    }

    private SwiftTagListBlock removeSubBlock(String blockName, boolean removeAll) {
        SwiftTagListBlock result = new SwiftTagListBlock();
        boolean inBlock = false;
        boolean blockRemoved = false;
        for (Tag t : this.tags) {
            if (blockRemoved && !removeAll) {
                result.append(t);
                continue;
            }
            if (Field16R.tag(blockName).equals(t) && !inBlock) {
                inBlock = true;
                continue;
            }
            if (Field16S.tag(blockName).equals(t) && inBlock) {
                inBlock = false;
                blockRemoved = true;
                continue;
            }
            if (inBlock) continue;
            result.append(t);
        }
        return result;
    }

    public boolean containsAnyOf(String ... name) {
        if (name != null && name.length > 0) {
            for (String s : name) {
                if (!this.containsTag(s)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAllOf(String ... name) {
        if (name != null && name.length > 0) {
            for (String s : name) {
                if (this.containsTag(s)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public SwiftTagListBlock filterByName(boolean include, String ... names) {
        SwiftTagListBlock result = new SwiftTagListBlock();
        if (names.length == 0) {
            if (!include) {
                result.setTags(this.getTags());
            }
        } else {
            Object[] tagnames = names;
            for (Tag t : this.tags) {
                boolean matched = false;
                for (int j = 0; !matched && j < tagnames.length; ++j) {
                    if (!StringUtils.equals((CharSequence)t.getName(), (CharSequence)tagnames[j])) continue;
                    matched = true;
                    tagnames = (String[])ArrayUtils.remove((Object[])tagnames, (int)j);
                }
                if (matched && include) {
                    result.append(t);
                }
                if (matched || include) continue;
                result.append(t);
            }
        }
        return result;
    }

    public SwiftTagListBlock filterByNameOrdered(String ... names) {
        Object[] tagnames = names;
        SwiftTagListBlock result = new SwiftTagListBlock();
        for (Tag t : this.getTags()) {
            boolean matched = false;
            for (int j = 0; !matched && j < tagnames.length; ++j) {
                if (!StringUtils.equals((CharSequence)t.getName(), (CharSequence)tagnames[j])) continue;
                matched = true;
                tagnames = (String[])ArrayUtils.remove((Object[])tagnames, (int)j);
                result.append(t);
            }
            if (matched) continue;
            break;
        }
        return result;
    }

    public List<SwiftTagListBlock> getSubBlocksDelimitedWithOptionalTail(String[] start, String[] end, String[] tail) {
        if (this.tags != null && !this.tags.isEmpty()) {
            ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
            int offset = 0;
            boolean done = false;
            while (!done) {
                int e;
                int s = this.indexOfAnyFirstAfterIndex(offset, start);
                offset = e = this.indexOfAnyFirstAfterIndex(s + 1, end);
                if (s == -1 || e == -1) {
                    done = true;
                    continue;
                }
                if (e < s) continue;
                SwiftTagListBlock l = this.sublist(s, e);
                if (tail != null && tail.length > 0) {
                    boolean abort = false;
                    for (int i = e + 1; i < this.tags.size() && !abort; ++i) {
                        boolean added = false;
                        for (String tn : tail) {
                            Tag tag = this.tags.get(i);
                            if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)tn)) continue;
                            l.append(tag);
                            ++offset;
                            added = true;
                        }
                        if (added) continue;
                        abort = true;
                    }
                }
                result.add(l);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SwiftTagListBlock> getSubBlocksByTagNames(Integer startIndex, String ... searchTags) {
        int start;
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        int n = start = startIndex != null ? startIndex : 0;
        while (start < this.tags.size()) {
            SwiftTagListBlock found = new SwiftTagListBlock();
            start = this.getSubBlockByTagNames(found, start, searchTags);
            ++start;
            if (found.isEmpty()) break;
            result.add(found);
        }
        return result;
    }

    public SwiftTagListBlock getSubBlockByTagNames(Integer startIndex, String ... searchTags) {
        SwiftTagListBlock block = new SwiftTagListBlock();
        this.getSubBlockByTagNames(block, startIndex, searchTags);
        return block;
    }

    private int getSubBlockByTagNames(SwiftTagListBlock target, Integer startIndex, String ... searchTags) {
        int tagsIndex;
        int searchIndex = 0;
        int lastAddedIndex = tagsIndex;
        block0: for (tagsIndex = startIndex != null ? startIndex : 0; tagsIndex < this.tags.size() && searchIndex < searchTags.length; ++tagsIndex) {
            Tag candidate = this.tags.get(tagsIndex);
            for (int j = searchIndex; j < searchTags.length; ++j) {
                if (!candidate.getName().equals(searchTags[j])) continue;
                target.append(candidate);
                searchIndex = j;
                lastAddedIndex = tagsIndex;
                continue block0;
            }
        }
        return lastAddedIndex;
    }

    public SwiftTagListBlock getSubBlockDelimitedWithOptionalTail(String[] start, String[] end, String[] tail) {
        if (this.tags != null && !this.tags.isEmpty()) {
            int s = this.indexOfAnyFirst(start);
            int e = this.indexOfAnyFirstAfterIndex(s + 1, end);
            if (s != -1 && e != -1 && e >= s) {
                SwiftTagListBlock result = this.sublist(s, e);
                if (tail == null || tail.length == 0) {
                    return result;
                }
                boolean abort = false;
                for (int i = e + 1; i < this.tags.size() && !abort; ++i) {
                    boolean added = false;
                    for (String tn : tail) {
                        if (!StringUtils.equals((CharSequence)this.tags.get(i).getName(), (CharSequence)tn)) continue;
                        result.append(this.tags.get(i));
                        added = true;
                    }
                    if (added) continue;
                    abort = true;
                }
                return result;
            }
        }
        return null;
    }

    public SwiftTagListBlock getOptionalList(String[][] optionalTags) {
        return this.getOptionalList(optionalTags, 0);
    }

    public SwiftTagListBlock getOptionalList(String[][] optionalTags, int startAt) {
        if (this.tags != null && !this.tags.isEmpty()) {
            SwiftTagListBlock result = new SwiftTagListBlock();
            boolean done = false;
            int t = startAt;
            int rowPointer = 0;
            do {
                Tag tag;
                int rowIndex;
                if ((rowIndex = this.findTagInRowSince(tag = this.tags.get(t++), rowPointer, optionalTags)) >= 0) {
                    rowPointer = rowIndex + 1;
                    result.append(tag);
                    continue;
                }
                done = true;
            } while (!done);
            return result;
        }
        return null;
    }

    private int findTagInRowSince(Tag tag, int rowPointer, String[][] optionalTags) {
        for (int r = rowPointer; r < optionalTags.length; ++r) {
            String[] row = optionalTags[r];
            for (int i = 0; i < row.length; ++i) {
                String op = row[i];
                if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)op)) continue;
                return r;
            }
        }
        return -1;
    }

    public List<SwiftTagListBlock> getOptionalLists(String[][] optionalTags) {
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        if (this.tags != null && !this.tags.isEmpty()) {
            boolean done = false;
            int offset = 0;
            while (!done) {
                SwiftTagListBlock o;
                if ((offset += (o = this.getOptionalList(optionalTags, offset)).size()) > this.tags.size() || o.isEmpty()) {
                    done = true;
                }
                if (o.isEmpty()) continue;
                result.add(o);
            }
        }
        return result;
    }

    public List<String> tagNamesList() {
        if (this.tags == null || this.tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Tag t : this.tags) {
            result.add(t.getName());
        }
        return result;
    }

    public int countTagsStarsWith(String name, String value) {
        int result = 0;
        if (this.tags != null && !this.tags.isEmpty()) {
            for (Tag t : this.tags) {
                if (!StringUtils.equals((CharSequence)name, (CharSequence)t.getName()) || !t.startsWith(value)) continue;
                ++result;
            }
        }
        return result;
    }

    public SwiftTagListBlock removeAfterFirstStartsWith(String name, String startsWith) {
        if (this.tags == null || !this.tags.isEmpty()) {
            return new SwiftTagListBlock();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        boolean done = false;
        for (int i = 0; i < this.tags.size() && !done; ++i) {
            Tag t = this.tags.get(i);
            if (StringUtils.equals((CharSequence)t.getName(), (CharSequence)name) && t.startsWith(startsWith)) {
                done = true;
                continue;
            }
            tags.add(t);
        }
        return new SwiftTagListBlock(tags);
    }

    @Deprecated
    public String toJsonV1() {
        DeprecationUtils.phase3(this.getClass(), "toJsonV1()", "use toJson() instead");
        StringBuilder sb = new StringBuilder();
        sb.append("[ \n");
        if (this.tags != null && !this.tags.isEmpty()) {
            for (int i = 0; i < this.tags.size(); ++i) {
                Tag t = this.tags.get(i);
                sb.append("{ \"").append(t.getName()).append("\" : \"").append(this.escapeJson(t.getValue())).append("\" }");
                if (i + 1 < this.tags.size()) {
                    sb.append(',');
                }
                sb.append('\n');
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String escapeJson(String value) {
        String tmp = StringUtils.replace((String)value, (String)"\n", (String)"\\n");
        tmp = StringUtils.replace((String)tmp, (String)"\"", (String)"\\\"");
        tmp = StringUtils.remove((String)tmp, (String)"\r");
        return tmp;
    }

    public String toJson() {
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)this);
    }

    public SwiftTagListBlock append(SwiftTagListBlock block) {
        if (block != null && !block.isEmpty()) {
            this.tags.addAll(block.getTags());
        }
        return this;
    }

    public SwiftTagListBlock append(SwiftTagListBlock ... blocks) {
        if (blocks != null && blocks.length > 0) {
            for (SwiftTagListBlock b : blocks) {
                this.tags.addAll(b.getTags());
            }
        }
        return this;
    }

    public SwiftTagListBlock append(Tag tag) {
        Validate.notNull((Object)tag);
        this.tags.add(tag);
        return this;
    }

    public SwiftTagListBlock append(Tag ... tags) {
        if (tags != null && tags.length > 0) {
            for (Tag t : tags) {
                this.tags.add(t);
            }
        }
        return this;
    }

    public SwiftTagListBlock append(Field field) {
        Validate.notNull((Object)field);
        this.tags.add(field.asTag());
        return this;
    }

    public SwiftTagListBlock append(Field ... fields) {
        if (fields != null && fields.length > 0) {
            for (Field f : fields) {
                this.append(f);
            }
        }
        return this;
    }

    @Override
    public Iterator<Tag> iterator() {
        if (this.tags == null) {
            return Collections.emptyList().iterator();
        }
        return this.tags.iterator();
    }

    public Tag[] asTagArray() {
        if (this.size() > 0) {
            Tag[] result = new Tag[this.size()];
            int i = 0;
            for (Tag t : this.tags) {
                result[i++] = t;
            }
            return result;
        }
        return new Tag[0];
    }

    public SwiftTagListBlock clear() {
        if (this.tags != null) {
            this.tags.clear();
        }
        return this;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Integer getNumber() {
        return null;
    }

    @Override
    protected void setBlockName(String blockName) {
    }

    @Override
    protected void setBlockNumber(Integer blockNumber) {
    }

    public void visit(TagVisitor visitor) {
        if (visitor != null && this.tags != null && !this.tags.isEmpty()) {
            for (Tag t : this.tags) {
                visitor.onTag(t);
            }
        }
    }

    public List<Field> fields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Tag tag : this.tags) {
            fields.add(tag.asField());
        }
        return fields;
    }

    public List<SwiftTagListBlock> splitByTagName(int tagNumber, String letterOption) {
        if (letterOption != null) {
            Validate.isTrue((StringUtils.length((CharSequence)letterOption) == 1 ? 1 : 0) != 0, (String)"letter option must be only one character", (Object[])new Object[0]);
        }
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        SwiftTagListBlock currentBlock = null;
        for (Tag t : this.tags) {
            if (t.getNumber() == tagNumber) {
                String letter = t.getLetterOption();
                if (letterOption == null || letterOption.equals(letter)) {
                    currentBlock = new SwiftTagListBlock();
                    result.add(currentBlock);
                }
            }
            if (currentBlock == null) continue;
            currentBlock.append(t);
        }
        return result;
    }

    private static enum SearchBoundary {
        FIRST_TAG_NAME,
        FIRST_TAG_IGNORE_CR,
        LAST_TAG_NAME;

    }

    private static enum SearchSelection {
        BEFORE,
        AFTER;

    }

    private static final class EmptyItr
    implements Iterator<Tag> {
        private EmptyItr() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Tag next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove on an empty iterator");
        }
    }
}

