/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SequenceNode;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.model.field.Field;
import java.io.Serializable;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Tag
implements Serializable {
    private static final transient Logger log = Logger.getLogger(Tag.class.getName());
    private static final long serialVersionUID = -1066430327311949399L;
    @Deprecated
    protected Long id;
    @Deprecated
    protected Integer sortKey;
    protected String name;
    protected String value;
    protected UnparsedTextList unparsedTexts = null;
    @Deprecated
    protected transient SequenceNode sequence = null;

    public Tag() {
    }

    public Tag(String inner) {
        Validate.notNull((Object)inner, (String)"parameter 'inner' cannot be null", (Object[])new Object[0]);
        int i = inner.indexOf(58);
        if (i >= 0) {
            if (i > 0) {
                this.name = inner.substring(0, i);
            }
            if (i + 1 < inner.length()) {
                this.value = inner.substring(i + 1);
            }
        } else if (inner.length() > 0) {
            this.value = inner;
        }
    }

    public Tag(String tagname, String value) {
        Validate.notNull((Object)tagname, (String)"parameter 'tagname' cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"parameter 'value' cannot be null", (Object[])new Object[0]);
        this.name = tagname;
        this.value = value;
    }

    public Tag(UnparsedTextList unparsedText) {
        this();
        this.unparsedTexts = unparsedText;
    }

    public Tag(String inner, UnparsedTextList unparsedText) {
        this(inner);
        this.unparsedTexts = unparsedText;
    }

    public Tag(String tagname, String value, UnparsedTextList unparsedText) {
        this(tagname, value);
        this.unparsedTexts = unparsedText;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Validate.notNull((Object)name, (String)"parameter 'name' cannot be null", (Object[])new Object[0]);
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "Tag[" + this.name + ":" + this.value + "]";
    }

    @Deprecated
    public Long getId() {
        DeprecationUtils.phase3(this.getClass(), "getId()", "The SwiftMessage model is no more intended for persistence, use the more effective JPA annotated model in AbstractSwiftMessage instead");
        return this.id;
    }

    @Deprecated
    public void setId(Long id) {
        DeprecationUtils.phase3(this.getClass(), "setId(Long)", "The SwiftMessage model is no more intended for persistence, use the more effective JPA annotated model in AbstractSwiftMessage instead");
        this.id = id;
    }

    @Deprecated
    public Integer getSortKey() {
        DeprecationUtils.phase3(this.getClass(), "getSortKey()", "The SwiftMessage model is no more intended for persistence, use the more effective JPA annotated model in AbstractSwiftMessage instead");
        return this.sortKey;
    }

    @Deprecated
    public void setSortKey(Integer sortKey) {
        DeprecationUtils.phase3(this.getClass(), "setSortKey(Integer)", "The SwiftMessage model is no more intended for persistence, use the more effective JPA annotated model in AbstractSwiftMessage instead");
        this.sortKey = sortKey;
    }

    protected void unparsedTextVerify() {
        if (this.unparsedTexts == null) {
            this.unparsedTexts = new UnparsedTextList();
        }
    }

    public UnparsedTextList getUnparsedTexts() {
        this.unparsedTextVerify();
        return this.unparsedTexts;
    }

    public void setUnparsedTexts(UnparsedTextList texts) {
        this.unparsedTexts = texts;
    }

    public Integer getUnparsedTextsSize() {
        if (this.unparsedTexts == null) {
            return new Integer(0);
        }
        return this.unparsedTexts.size();
    }

    public Boolean unparsedTextIsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.isMessage(index);
    }

    public String unparsedTextGetText(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getText(index);
    }

    public SwiftMessage unparsedTextGetAsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getTextAsMessage(index);
    }

    public void unparsedTextAddText(String text) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(text);
    }

    public void unparsedTextAddText(SwiftMessage message) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.name, tag.name) && Objects.equals(this.value, tag.value) && Objects.equals(this.unparsedTexts, tag.unparsedTexts);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.unparsedTexts);
    }

    public boolean equalsIgnoreCR(Tag other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.sortKey == null ? other.sortKey != null : !this.sortKey.equals(other.sortKey)) {
            return false;
        }
        if (this.unparsedTexts == null ? other.unparsedTexts != null : !this.unparsedTexts.equals(other.unparsedTexts)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !StringUtils.replace((String)this.value, (String)"\r", (String)"").equals(StringUtils.replace((String)other.value, (String)"\r", (String)"")));
    }

    public int getNameAsInt() {
        try {
            return Integer.parseInt(this.name);
        }
        catch (Exception unused) {
            return -1;
        }
    }

    public boolean isNumber(int n) {
        return this.name != null && this.getNumber() != null && this.getNumber().equals(n);
    }

    public Integer getNumber() {
        if (this.name != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.name.length(); ++i) {
                char c = this.name.charAt(i);
                if (!Character.isDigit(c)) continue;
                sb.append(c);
            }
            if (sb.length() > 0) {
                return Integer.parseInt(sb.toString());
            }
        }
        return null;
    }

    public String getLetterOption() {
        if (this.name != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.name.length(); ++i) {
                char c = this.name.charAt(i);
                if (!Character.isLetter(c)) continue;
                sb.append(c);
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }

    @Deprecated
    public Field getField() {
        DeprecationUtils.phase3(this.getClass(), "getField()", "use asField() instead");
        return Field.getField(this);
    }

    public boolean contains(String ... values) {
        if (values != null && values.length > 0) {
            String _v = this.getValue();
            for (String v : values) {
                if (!StringUtils.contains((CharSequence)_v, (CharSequence)v)) continue;
                return true;
            }
        }
        return false;
    }

    public void setNameValue(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public boolean startsWith(String prefix) {
        return StringUtils.startsWith((CharSequence)this.getValue(), (CharSequence)prefix);
    }

    public boolean contains(String searchStr) {
        return StringUtils.contains((CharSequence)this.getValue(), (CharSequence)searchStr);
    }

    public Field asField() {
        return Field.getField(this);
    }
}

