/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field129
extends Field
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "129";
    public static final String F_129 = "129";
    public static final String PARSER_PATTERN = "S/S";
    public static final String COMPONENTS_PATTERN = "NN";
    public static final Integer SECTION = 1;
    public static final Integer TOTAL = 2;

    public Field129() {
        super(2);
    }

    public Field129(String value) {
        super(value);
    }

    public Field129(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"129")) {
            throw new IllegalArgumentException("cannot create field 129 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field129 newInstance(Field129 source) {
        Field129 cp = new Field129();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("129", value);
    }

    public static Tag emptyTag() {
        return new Tag("129", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        NumberFormat f;
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 129");
        }
        if (component == 1) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent1AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 2) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "2n/2n";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Section");
        result.add("Total");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "section");
        result.put(2, "total");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getSection() {
        return this.getComponent(1);
    }

    public Number getSectionAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getTotal() {
        return this.getComponent(2);
    }

    public Number getTotalAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field129 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field129 setComponent1(Number component1) {
        if (component1 != null) {
            this.setComponent(1, Integer.toString(component1.intValue()));
        }
        return this;
    }

    public Field129 setSection(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field129 setSection(Number component1) {
        this.setComponent1(component1);
        return this;
    }

    public Field129 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field129 setComponent2(Number component2) {
        if (component2 != null) {
            this.setComponent(2, Integer.toString(component2.intValue()));
        }
        return this;
    }

    public Field129 setTotal(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field129 setTotal(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public String getName() {
        return "129";
    }

    public static Field129 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("129");
        if (t == null) {
            return null;
        }
        return new Field129(t);
    }

    public static Field129 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field129.get(msg.getBlock4());
    }

    public static List<Field129> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field129.getAll(msg.getBlock4());
    }

    public static List<Field129> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("129");
        if (arr != null && arr.length > 0) {
            ArrayList<Field129> result = new ArrayList<Field129>(arr.length);
            for (Tag f : arr) {
                result.add(new Field129(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field129 fromJson(String json) {
        Field129 field = new Field129();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("section") != null) {
            field.setComponent1(jsonObject.get("section").getAsString());
        }
        if (jsonObject.get("total") != null) {
            field.setComponent2(jsonObject.get("total").getAsString());
        }
        return field;
    }
}

