/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field23R
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "23R";
    public static final String F_23R = "23R";
    public static final String PARSER_PATTERN = "S[$S]0-6";
    public static final String COMPONENTS_PATTERN = "SSSSSSS";
    public static final Integer CODE = 1;
    public static final Integer TEXT = 2;

    public Field23R() {
        super(7);
    }

    public Field23R(String value) {
        super(value);
    }

    public Field23R(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"23R")) {
            throw new IllegalArgumentException("cannot create field 23R from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field23R newInstance(Field23R source) {
        Field23R cp = new Field23R();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("23R", value);
    }

    public static Tag emptyTag() {
        return new Tag("23R", "");
    }

    @Override
    public void parse(String value) {
        this.init(7);
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 1, null, 0, lines);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.appendInLines(result, 1, 7);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 7) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 23R");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        if (component == 7) {
            return this.getComponent(7);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "4!c(**)[$35x]0-6";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        if (component == 6) {
            return true;
        }
        return component == 7;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 7;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Code");
        result.add("Text");
        result.add("Text 2");
        result.add("Text 3");
        result.add("Text 4");
        result.add("Text 5");
        result.add("Text 6");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "code");
        result.put(2, "text");
        result.put(3, "text2");
        result.put(4, "text3");
        result.put(5, "text4");
        result.put(6, "text5");
        result.put(7, "text6");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getCode() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getTextLine1() {
        return this.getComponent(2);
    }

    public String getTextLine2() {
        return this.getComponent(3);
    }

    public String getTextLine3() {
        return this.getComponent(4);
    }

    public String getTextLine4() {
        return this.getComponent(5);
    }

    public String getTextLine5() {
        return this.getComponent(6);
    }

    public String getTextLine6() {
        return this.getComponent(7);
    }

    public String getText() {
        StringBuilder result = new StringBuilder();
        for (int i = 2; i < 8; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public String getComponent7() {
        return this.getComponent(7);
    }

    public Field23R setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field23R setCode(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field23R setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field23R setTextLine1(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field23R setTextLine2(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field23R setTextLine3(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field23R setTextLine4(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field23R setTextLine5(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field23R setTextLine6(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    public Field23R setText(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 2, 6, 0, lines);
        return this;
    }

    public Field23R setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field23R setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field23R setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field23R setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field23R setComponent7(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    @Override
    public String getName() {
        return "23R";
    }

    public static Field23R get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("23R");
        if (t == null) {
            return null;
        }
        return new Field23R(t);
    }

    public static Field23R get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field23R.get(msg.getBlock4());
    }

    public static List<Field23R> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field23R.getAll(msg.getBlock4());
    }

    public static List<Field23R> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("23R");
        if (arr != null && arr.length > 0) {
            ArrayList<Field23R> result = new ArrayList<Field23R>(arr.length);
            for (Tag f : arr) {
                result.add(new Field23R(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field23R cp = Field23R.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field23R cp = Field23R.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field23R cp = Field23R.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field23R fromJson(String json) {
        Field23R field = new Field23R();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("code") != null) {
            field.setComponent1(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("text") != null) {
            field.setComponent2(jsonObject.get("text").getAsString());
        }
        if (jsonObject.get("text2") != null) {
            field.setComponent3(jsonObject.get("text2").getAsString());
        }
        if (jsonObject.get("text3") != null) {
            field.setComponent4(jsonObject.get("text3").getAsString());
        }
        if (jsonObject.get("text4") != null) {
            field.setComponent5(jsonObject.get("text4").getAsString());
        }
        if (jsonObject.get("text5") != null) {
            field.setComponent6(jsonObject.get("text5").getAsString());
        }
        if (jsonObject.get("text6") != null) {
            field.setComponent7(jsonObject.get("text6").getAsString());
        }
        return field;
    }
}

