/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field98G
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "98G";
    public static final String F_98G = "98G";
    public static final String PARSER_PATTERN = "<DATE4><TIME2>[,S][/[c]<TIME3>]";
    public static final String COMPONENTS_PATTERN = "DTNCW";
    public static final Integer DATE = 1;
    public static final Integer TIME = 2;
    public static final Integer NUMBER = 3;
    public static final Integer SIGN = 4;
    public static final Integer OFFSET = 5;
    @Deprecated
    public static final Integer TIME_2 = 5;

    public Field98G() {
        super(5);
    }

    public Field98G(String value) {
        super(value);
    }

    public Field98G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"98G")) {
            throw new IllegalArgumentException("cannot create field 98G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field98G newInstance(Field98G source) {
        Field98G cp = new Field98G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("98G", value);
    }

    public static Tag emptyTag() {
        return new Tag("98G", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        if (value != null) {
            if (value.length() >= 8) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)8));
            }
            if (value.length() >= 14) {
                this.setComponent2(StringUtils.substring((String)value, (int)8, (int)14));
            }
            if (value.length() > 14) {
                String toparse2 = StringUtils.substring((String)value, (int)14);
                this.setComponent3(SwiftParseUtils.getTokenFirst(toparse2, ",", "/"));
                String toparse3 = SwiftParseUtils.getTokenSecondLast(toparse2, "/");
                if (toparse3 != null) {
                    if (toparse3.length() < 2) {
                        this.setComponent4(toparse3);
                    } else if (toparse3.length() == 2 || toparse3.length() == 4) {
                        this.setComponent5(toparse3);
                    } else if (toparse3.length() == 3 || toparse3.length() == 5) {
                        this.setComponent4(StringUtils.substring((String)toparse3, (int)0, (int)1));
                        this.setComponent5(StringUtils.substring((String)toparse3, (int)1));
                    } else if (toparse3.length() > 4) {
                        this.setComponent4(SwiftParseUtils.getAlphaPrefix(toparse3));
                        this.setComponent5(SwiftParseUtils.getNumericSuffix(toparse3));
                    }
                }
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        if (this.getComponent3() != null) {
            result.append(",").append(this.getComponent3());
        }
        if (this.getComponent4() != null || this.getComponent5() != null) {
            result.append("/");
            this.append(result, 4);
            this.append(result, 5);
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        Format f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 98G");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 2) {
            f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            Number n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent5AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<DATE4><TIME2>[,3n][/[<N>]<TIME3>]";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 3) {
            return true;
        }
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Time");
        result.add("Number");
        result.add("Sign");
        result.add("Offset");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        result.put(2, "time");
        result.put(3, "number");
        result.put(4, "sign");
        result.put(5, "offset");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent(1);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(2));
    }

    public String getTime() {
        return this.getComponent(2);
    }

    public Calendar getTimeAsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(2));
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getNumber() {
        return this.getComponent(3);
    }

    public Number getNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Currency getComponent4AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public String getSign() {
        return this.getComponent(4);
    }

    public Currency getSignAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Calendar getComponent5AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(5));
    }

    public String getOffset() {
        return this.getComponent(5);
    }

    public Calendar getOffsetAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(5));
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(1)));
        result.add(SwiftFormatUtils.getTime2(this.getComponent(2)));
        result.add(SwiftFormatUtils.getTime3(this.getComponent(5)));
        return result;
    }

    public Field98G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field98G setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate4(component1));
        return this;
    }

    public Field98G setDate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field98G setDate(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    public Field98G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field98G setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getTime2(component2));
        return this;
    }

    public Field98G setTime(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field98G setTime(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public Field98G setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field98G setComponent3(Number component3) {
        if (component3 != null) {
            this.setComponent(3, Integer.toString(component3.intValue()));
        }
        return this;
    }

    public Field98G setNumber(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field98G setNumber(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    public Field98G setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field98G setComponent4(Currency component4) {
        this.setComponent(4, SwiftFormatUtils.getCurrency(component4));
        return this;
    }

    public Field98G setSign(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field98G setSign(Currency component4) {
        this.setComponent4(component4);
        return this;
    }

    public Field98G setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field98G setComponent5(Calendar component5) {
        this.setComponent(5, SwiftFormatUtils.getTime3(component5));
        return this;
    }

    public Field98G setOffset(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field98G setOffset(Calendar component5) {
        this.setComponent5(component5);
        return this;
    }

    @Override
    public String getName() {
        return "98G";
    }

    public static Field98G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("98G");
        if (t == null) {
            return null;
        }
        return new Field98G(t);
    }

    public static Field98G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field98G.get(msg.getBlock4());
    }

    public static List<Field98G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field98G.getAll(msg.getBlock4());
    }

    public static List<Field98G> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("98G");
        if (arr != null && arr.length > 0) {
            ArrayList<Field98G> result = new ArrayList<Field98G>(arr.length);
            for (Tag f : arr) {
                result.add(new Field98G(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field98G fromJson(String json) {
        Field98G field = new Field98G();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent2(jsonObject.get("time").getAsString());
        }
        if (jsonObject.get("number") != null) {
            field.setComponent3(jsonObject.get("number").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent4(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("offset") != null) {
            field.setComponent5(jsonObject.get("offset").getAsString());
        }
        return field;
    }

    public String getUtcIndicator() {
        if (this.getOffset() != null) {
            if (this.getSign() != null && this.getSign().equals("N")) {
                return "-" + StringUtils.trimToEmpty((String)this.getOffset());
            }
            return "+" + StringUtils.trimToEmpty((String)this.getOffset());
        }
        return null;
    }

    @Deprecated
    public String getTime2() {
        return this.getOffset();
    }

    @Deprecated
    public Calendar getTime2AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getOffset());
    }

    @Deprecated
    public Field98G setTime2(String component) {
        return this.setOffset(component);
    }

    @Deprecated
    public Field98G setTime2(Calendar cal) {
        return this.setOffset(cal);
    }
}

