/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.StructuredNarrative;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class Narrative {
    private List<StructuredNarrative> structured = new ArrayList<StructuredNarrative>();
    private List<String> unstructuredFragments = new ArrayList<String>();

    Narrative() {
    }

    public List<StructuredNarrative> getStructured() {
        return this.structured;
    }

    public StructuredNarrative getStructured(String codeword) {
        if (this.structured != null) {
            for (StructuredNarrative structured : this.structured) {
                if (!StringUtils.equals((CharSequence)codeword, (CharSequence)structured.getCodeword())) continue;
                return structured;
            }
        }
        return null;
    }

    public int countStructured(String codeword) {
        int count = 0;
        if (this.structured != null) {
            for (StructuredNarrative structured : this.structured) {
                if (!StringUtils.equals((CharSequence)codeword, (CharSequence)structured.getCodeword())) continue;
                ++count;
            }
        }
        return count;
    }

    Narrative add(StructuredNarrative structuredNarrative) {
        this.structured.add(structuredNarrative);
        return this;
    }

    public List<String> getUnstructuredFragments() {
        return this.unstructuredFragments;
    }

    Narrative addUnstructuredFragment(String narrativeFragment) {
        this.unstructuredFragments.add(narrativeFragment);
        return this;
    }

    public String getUnstructured() {
        return this.getUnstructured(null);
    }

    public String getUnstructured(String delimiter) {
        if (!this.unstructuredFragments.isEmpty()) {
            String s = delimiter != null ? delimiter : "";
            return String.join((CharSequence)s, this.unstructuredFragments);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.structured.isEmpty() && this.unstructuredFragments.isEmpty();
    }

    public boolean valid() {
        return !this.unstructuredFragments.isEmpty() || this.validStructured();
    }

    private boolean validStructured() {
        for (StructuredNarrative structured : this.structured) {
            if (structured.valid()) continue;
            return false;
        }
        return true;
    }

    public Set<String> codewords() {
        HashSet<String> result = new HashSet<String>();
        for (StructuredNarrative s : this.structured) {
            if (s.getCodeword() == null) continue;
            result.add(s.getCodeword());
        }
        return result;
    }

    public String getValue() {
        StringBuilder result = new StringBuilder();
        for (StructuredNarrative structured : this.structured) {
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append("/").append(StringUtils.trimToEmpty((String)structured.getCodeword())).append("/");
            if (structured.getCountry() != null) {
                result.append(structured.getCountry());
            } else if (structured.getCurrency() != null || structured.getAmount() != null) {
                result.append(StringUtils.trimToEmpty((String)structured.getCurrency()));
                if (structured.getAmount() != null) {
                    result.append(structured.getAmount());
                }
            }
            boolean first = true;
            for (String fragment : structured.getNarrativeFragments()) {
                if (!first) {
                    result.append("\r\n").append("//");
                } else if (structured.getCountry() != null) {
                    result.append("//");
                }
                result.append(fragment);
                first = false;
            }
            first = true;
            for (String fragment : structured.getNarrativeSupplementFragments()) {
                if (first) {
                    result.append("/");
                } else {
                    result.append("\r\n").append("//");
                }
                result.append(fragment);
                first = false;
            }
        }
        for (String fragment : this.unstructuredFragments) {
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(fragment);
        }
        return result.toString();
    }

    private Narrative(Builder builder) {
        this.structured = builder.structured;
        this.unstructuredFragments = builder.unstructuredFragments;
    }

    public static Builder builder(int lineLength) {
        return new Builder(lineLength);
    }

    public static class Builder {
        int lineLength;
        private List<StructuredNarrative> structured = new ArrayList<StructuredNarrative>();
        private List<String> unstructuredFragments = new ArrayList<String>();

        public Builder(int lineLength) {
            this.lineLength = lineLength;
        }

        public Builder addCodeword(String codeword, String narrative) {
            StructuredNarrative structured = new StructuredNarrative().setCodeword(codeword);
            String prefix = "/" + StringUtils.trim((String)codeword) + "/";
            for (String fragment : this.wrap(prefix, narrative)) {
                structured.addNarrativeFragment(fragment);
            }
            this.structured.add(structured);
            return this;
        }

        public Builder addCodewordWithAmount(String codeword, String currency, BigDecimal amount, String narrative) {
            StructuredNarrative structured = new StructuredNarrative().setCodeword(codeword).setCurrency(currency).setAmount(amount);
            String amountString = amount != null ? amount.toString() : "";
            String prefix = "/" + StringUtils.trim((String)codeword) + "/" + StringUtils.trim((String)currency) + amountString;
            for (String fragment : this.wrap(prefix, narrative)) {
                structured.addNarrativeFragment(fragment);
            }
            this.structured.add(structured);
            return this;
        }

        public Builder addCodewordWithCountry(String codeword, String country, String narrative) {
            StructuredNarrative structured = new StructuredNarrative().setCodeword(codeword).setCountry(country);
            String countrySlash = country != null ? country + "//" : "";
            String prefix = "/" + StringUtils.trim((String)codeword) + countrySlash;
            for (String fragment : this.wrap(prefix, narrative)) {
                structured.addNarrativeFragment(fragment);
            }
            this.structured.add(structured);
            return this;
        }

        public Builder addCodewordWithSupplement(String number, String narrative, String supplement) {
            StructuredNarrative structured = new StructuredNarrative();
            String codeword = number != null ? number : "";
            structured.setCodeword(codeword);
            String prefix = "/" + codeword + "/";
            String text = supplement != null ? narrative + "/" + supplement : narrative;
            boolean isSupplement = false;
            for (String fragment : this.wrap(prefix, text)) {
                if (!isSupplement && fragment.indexOf(47) >= 0) {
                    String primatyText = StringUtils.substringBefore((String)fragment, (String)"/");
                    String supplementText = StringUtils.substringAfter((String)fragment, (String)"/");
                    structured.addNarrativeFragment(primatyText);
                    structured.addNarrativeSupplementFragment(supplementText);
                    isSupplement = true;
                    continue;
                }
                if (isSupplement) {
                    structured.addNarrativeSupplementFragment(fragment);
                    continue;
                }
                structured.addNarrativeFragment(fragment);
            }
            this.structured.add(structured);
            return this;
        }

        public Builder addUnstructured(String narrative) {
            String wrapped = WordUtils.wrap((String)narrative, (int)this.lineLength, (String)"\r\n", (boolean)true);
            String[] lines = wrapped.split("\r\n");
            this.unstructuredFragments.addAll(Arrays.asList(lines));
            return this;
        }

        private List<String> wrap(String prefix, String narrative) {
            String text = prefix + StringUtils.trimToEmpty((String)narrative);
            String wrapped = WordUtils.wrap((String)text, (int)this.lineLength, (String)"\r\n", (boolean)true);
            String[] lines = wrapped.split("\r\n");
            ArrayList<String> fragments = new ArrayList<String>();
            boolean first = true;
            for (String line : lines) {
                String fragment = first ? StringUtils.trimToNull((String)StringUtils.substringAfter((String)line, (String)prefix)) : StringUtils.trimToNull((String)line);
                if (fragment == null) continue;
                fragments.add(fragment);
                first = false;
            }
            return fragments;
        }

        public Narrative build() {
            return new Narrative(this);
        }
    }
}

