/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field29S
extends Field
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "29S";
    public static final String F_29S = "29S";
    public static final String PARSER_PATTERN = "S/S";
    public static final String COMPONENTS_PATTERN = "SS";
    public static final Integer CODE = 1;
    public static final Integer PARTY_IDENTIFIER = 2;

    public Field29S() {
        super(2);
    }

    public Field29S(String value) {
        super(value);
    }

    public Field29S(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"29S")) {
            throw new IllegalArgumentException("cannot create field 29S from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field29S newInstance(Field29S source) {
        Field29S cp = new Field29S();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("29S", value);
    }

    public static Tag emptyTag() {
        return new Tag("29S", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 29S");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "4!c/35x";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Code");
        result.add("Party Identifier");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "code");
        result.put(2, "partyIdentifier");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getCode() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getPartyIdentifier() {
        return this.getComponent(2);
    }

    public Field29S setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field29S setCode(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field29S setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field29S setPartyIdentifier(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    @Override
    public String getName() {
        return "29S";
    }

    public static Field29S get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("29S");
        if (t == null) {
            return null;
        }
        return new Field29S(t);
    }

    public static Field29S get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field29S.get(msg.getBlock4());
    }

    public static List<Field29S> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field29S.getAll(msg.getBlock4());
    }

    public static List<Field29S> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("29S");
        if (arr != null && arr.length > 0) {
            ArrayList<Field29S> result = new ArrayList<Field29S>(arr.length);
            for (Tag f : arr) {
                result.add(new Field29S(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field29S fromJson(String json) {
        Field29S field = new Field29S();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("code") != null) {
            field.setComponent1(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("partyIdentifier") != null) {
            field.setComponent2(jsonObject.get("partyIdentifier").getAsString());
        }
        return field;
    }
}

