/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field311;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT090
extends AbstractMT
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT090.class.getName());
    public static final String NAME = "090";

    public MT090(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT090(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT090 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT090(m);
    }

    public MT090() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT090(String sender, String receiver) {
        super(90, sender, receiver);
    }

    public MT090(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT090.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT090 object from FIN content with a Service Message. Check if the MT090 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT090 object from FIN content with message type " + param.getType());
        }
    }

    public static MT090 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT090(fin);
    }

    public MT090(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT090 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT090(stream);
    }

    public MT090(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT090 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT090(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT090 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT090 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT090 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT090 fromJson(String json) {
        return (MT090)AbstractMT.fromJson(json);
    }

    public Field311 getField311() {
        Tag t = this.tag("311");
        if (t != null) {
            return new Field311(t.getValue());
        }
        return null;
    }
}

