/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt4xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32K;
import com.prowidesoftware.swift.model.field.Field33A;
import com.prowidesoftware.swift.model.field.Field33K;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field74;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT430
extends AbstractMT
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT430.class.getName());
    public static final String NAME = "430";

    public MT430(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT430(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT430 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT430(m);
    }

    public MT430() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT430(String sender, String receiver) {
        super(430, sender, receiver);
    }

    public MT430(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT430.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT430 object from FIN content with a Service Message. Check if the MT430 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT430 object from FIN content with message type " + param.getType());
        }
    }

    public static MT430 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT430(fin);
    }

    public MT430(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT430 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT430(stream);
    }

    public MT430(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT430 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT430(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT430 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT430 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT430 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT430 fromJson(String json) {
        return (MT430)AbstractMT.fromJson(json);
    }

    public Field59 getField59() {
        Tag t = this.tag("59");
        if (t != null) {
            return new Field59(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public Field74 getField74() {
        Tag t = this.tag("74");
        if (t != null) {
            return new Field74(t.getValue());
        }
        return null;
    }

    public List<Field20> getField20() {
        ArrayList<Field20> result = new ArrayList<Field20>();
        Tag[] tags = this.tags("20");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field21(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32A> getField32A() {
        ArrayList<Field32A> result = new ArrayList<Field32A>();
        Tag[] tags = this.tags("32A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32K> getField32K() {
        ArrayList<Field32K> result = new ArrayList<Field32K>();
        Tag[] tags = this.tags("32K");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32K(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field33A> getField33A() {
        ArrayList<Field33A> result = new ArrayList<Field33A>();
        Tag[] tags = this.tags("33A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field33A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field33K> getField33K() {
        ArrayList<Field33K> result = new ArrayList<Field33K>();
        Tag[] tags = this.tags("33K");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field33K(tag.getValue()));
            }
        }
        return result;
    }

    public List<SequenceA> getSequenceAList() {
        return MT430.getSequenceAList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceA> getSequenceAList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL)) != null && !blocks.isEmpty()) {
            ArrayList<SequenceA> result = new ArrayList<SequenceA>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                result.add(new SequenceA(b));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_NAME = null;

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"21"};
        protected static final String[] TAIL = new String[]{"32A", "32K", "33A", "33K"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

