/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.writer;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;

public class MultilineUtil {
    private static final transient Logger log = Logger.getLogger(MultilineUtil.class.getName());

    public String[] removeInnerEmptyLines(String[] lines) {
        return this.removeInnerEmptyLines(lines, false);
    }

    public String[] removeInnerEmptyLines(String[] lines, boolean keepAll) {
        Validate.notNull((Object)lines, (String)"lines cannot be null", (Object[])new Object[0]);
        if (lines.length == 0) {
            return lines;
        }
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<String> empty = null;
        if (keepAll) {
            empty = new ArrayList<String>();
        }
        for (int i = 0; i < lines.length; ++i) {
            if (this.isEmpty(lines[i])) {
                if (!keepAll) continue;
                empty.add(lines[i]);
                continue;
            }
            text.add(lines[i]);
        }
        if (keepAll) {
            text.addAll(empty);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("text: " + text);
        }
        return text.toArray(new String[text.size()]);
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }
}

