/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.swift.model.SwiftBlock5Field;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SwiftBlock5
extends SwiftTagListBlock
implements Serializable {
    private static final transient Logger log = Logger.getLogger(SwiftBlock5.class.getName());
    private static final long serialVersionUID = 3114133378482486859L;

    public SwiftBlock5() {
    }

    public SwiftBlock5(List<Tag> tags) {
        Validate.notNull(tags, (String)"parameter 'tags' cannot be null", (Object[])new Object[0]);
        this.addTags(tags);
    }

    public static SwiftBlock5 fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (SwiftBlock5)gson.fromJson(json, SwiftBlock5.class);
    }

    @Override
    protected void setBlockNumber(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null", (Object[])new Object[0]);
        Validate.isTrue((blockNumber == 5 ? 1 : 0) != 0, (String)"blockNumber must be 5", (Object[])new Object[0]);
    }

    @Override
    protected void setBlockName(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null", (Object[])new Object[0]);
        Validate.isTrue((blockName.compareTo("5") == 0 ? 1 : 0) != 0, (String)"blockName must be string '5'", (Object[])new Object[0]);
    }

    @Override
    public Integer getNumber() {
        return 5;
    }

    @Override
    public String getName() {
        return "5";
    }

    public SwiftBlock5 setTag(SwiftBlock5Field field, String value) {
        String notNullValue = StringUtils.trimToEmpty((String)value);
        Tag t = this.getTagByName(field.name());
        if (t != null) {
            t.setValue(notNullValue);
        } else {
            this.append(new Tag(field.name(), notNullValue));
        }
        return this;
    }

    public Optional<Tag> getTag(SwiftBlock5Field field) {
        return Optional.ofNullable(this.getTagByName(field.name()));
    }

    public SwiftBlock5 setPDE() {
        return this.setTag(SwiftBlock5Field.PDE, null);
    }
}

