/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field12H
extends Field
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "12H";
    public static final String F_12H = "12H";
    public static final String PARSER_PATTERN = "S/S";
    public static final String COMPONENTS_PATTERN = "SS";
    public static final Integer CODE = 1;
    public static final Integer NARRATIVE = 2;

    public Field12H() {
        super(2);
    }

    public Field12H(String value) {
        super(value);
    }

    public Field12H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"12H")) {
            throw new IllegalArgumentException("cannot create field 12H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field12H newInstance(Field12H source) {
        Field12H cp = new Field12H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("12H", value);
    }

    public static Tag emptyTag() {
        return new Tag("12H", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 12H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "4!c[/35x]";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Code");
        result.add("Narrative");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "code");
        result.put(2, "narrative");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getCode() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNarrative() {
        return this.getComponent(2);
    }

    public Field12H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field12H setCode(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field12H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field12H setNarrative(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    @Override
    public String getName() {
        return "12H";
    }

    public static Field12H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("12H");
        if (t == null) {
            return null;
        }
        return new Field12H(t);
    }

    public static Field12H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field12H.get(msg.getBlock4());
    }

    public static List<Field12H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field12H.getAll(msg.getBlock4());
    }

    public static List<Field12H> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("12H");
        if (arr != null && arr.length > 0) {
            ArrayList<Field12H> result = new ArrayList<Field12H>(arr.length);
            for (Tag f : arr) {
                result.add(new Field12H(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field12H fromJson(String json) {
        Field12H field = new Field12H();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("code") != null) {
            field.setComponent1(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("narrative") != null) {
            field.setComponent2(jsonObject.get("narrative").getAsString());
        }
        return field;
    }
}

