/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field31R
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "31R";
    public static final String F_31R = "31R";
    public static final String PARSER_PATTERN = "<DATE2>[/<DATE2>]";
    public static final String COMPONENTS_PATTERN = "EE";
    public static final Integer DATE_1 = 1;
    public static final Integer DATE_2 = 2;

    public Field31R() {
        super(2);
    }

    public Field31R(String value) {
        super(value);
    }

    public Field31R(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"31R")) {
            throw new IllegalArgumentException("cannot create field 31R from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field31R newInstance(Field31R source) {
        Field31R cp = new Field31R();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("31R", value);
    }

    public static Tag emptyTag() {
        return new Tag("31R", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, null, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 31R");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date 1");
        result.add("Date 2");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date1");
        result.put(2, "date2");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getDate1() {
        return this.getComponent(1);
    }

    public Calendar getDate1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate2() {
        return this.getComponent(2);
    }

    public Calendar getDate2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(1)));
        result.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        return result;
    }

    public Field31R setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field31R setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate2(component1));
        return this;
    }

    public Field31R setDate1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field31R setDate1(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    public Field31R setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field31R setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field31R setDate2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field31R setDate2(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public String getName() {
        return "31R";
    }

    public static Field31R get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("31R");
        if (t == null) {
            return null;
        }
        return new Field31R(t);
    }

    public static Field31R get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field31R.get(msg.getBlock4());
    }

    public static List<Field31R> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field31R.getAll(msg.getBlock4());
    }

    public static List<Field31R> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("31R");
        if (arr != null && arr.length > 0) {
            ArrayList<Field31R> result = new ArrayList<Field31R>(arr.length);
            for (Tag f : arr) {
                result.add(new Field31R(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field31R fromJson(String json) {
        Field31R field = new Field31R();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("date1") != null) {
            field.setComponent1(jsonObject.get("date1").getAsString());
        }
        if (jsonObject.get("date2") != null) {
            field.setComponent2(jsonObject.get("date2").getAsString());
        }
        return field;
    }
}

