/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.BIC;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class LogicalTerminalAddress
extends BIC {
    private Character LTIdentifier = null;

    public LogicalTerminalAddress(String code) {
        if (code != null) {
            this.setInstitution(StringUtils.trimToNull((String)StringUtils.substring((String)code, (int)0, (int)4)));
            this.setCountry(StringUtils.trimToNull((String)StringUtils.substring((String)code, (int)4, (int)6)));
            this.setLocation(StringUtils.trimToNull((String)StringUtils.substring((String)code, (int)6, (int)8)));
            if (code.length() > 8) {
                if (code.length() == 9) {
                    this.LTIdentifier = Character.valueOf(code.charAt(8));
                } else if (code.length() >= 12) {
                    this.LTIdentifier = Character.valueOf(code.charAt(8));
                    this.branch = StringUtils.trimToNull((String)StringUtils.substring((String)code, (int)9));
                } else {
                    this.branch = StringUtils.trimToNull((String)StringUtils.substring((String)code, (int)8));
                }
            }
        }
    }

    public Character getLTIdentifier() {
        return this.LTIdentifier;
    }

    public void setLTIdentifier(Character lTIdentifier) {
        this.LTIdentifier = lTIdentifier;
    }

    public String getSenderLogicalTerminalAddress() {
        char LT;
        char c = LT = this.LTIdentifier == null || this.LTIdentifier.equals(Character.valueOf('X')) ? (char)'A' : (char)this.LTIdentifier.charValue();
        if (this.getBic8() != null) {
            return this.getBic8() + LT + this.getBranchOrDefault();
        }
        return null;
    }

    public String getReceiverLogicalTerminalAddress() {
        if (this.getBic8() != null) {
            return this.getBic8() + "X" + this.getBranchOrDefault();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogicalTerminalAddress that = (LogicalTerminalAddress)o;
        return Objects.equals(this.LTIdentifier, that.LTIdentifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.LTIdentifier);
    }
}

