/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.MessageDirection;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2OutputField;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;

public class SwiftBlock2Output
extends SwiftBlock2
implements Serializable {
    private static final long serialVersionUID = 6067091531833134527L;
    private static final transient Logger log = Logger.getLogger(SwiftBlock2.class.getName());
    private static final String SEPARATOR = "\", \n";
    private String senderInputTime;
    private String MIRDate;
    private String MIRLogicalTerminal;
    private String MIRSessionNumber;
    private String MIRSequenceNumber;
    private String receiverOutputDate;
    private String receiverOutputTime;

    public SwiftBlock2Output(String messageType, String senderInputTime, String MIRDate, String MIRLogicalTerminal, String MIRSessionNumber, String MIRSequenceNumber, String receiverOutputDate, String receiverOutputTime, String messagePriority) {
        this.output = true;
        this.messageType = messageType;
        this.senderInputTime = senderInputTime;
        this.MIRDate = MIRDate;
        this.MIRLogicalTerminal = MIRLogicalTerminal;
        this.MIRSessionNumber = MIRSessionNumber;
        this.MIRSequenceNumber = MIRSequenceNumber;
        this.receiverOutputDate = receiverOutputDate;
        this.receiverOutputTime = receiverOutputTime;
        this.messagePriority = messagePriority;
    }

    public SwiftBlock2Output(String value) {
        this(value, false);
    }

    public SwiftBlock2Output(String value, boolean lenient) {
        this.setValue(value, lenient);
    }

    public SwiftBlock2Output() {
    }

    public SwiftBlock2Output(SwiftBlock2Output block) {
        this(block.getMessageType(), block.getSenderInputTime(), block.getMIRDate(), block.getMIRLogicalTerminal(), block.getMIRSessionNumber(), block.getMIRSequenceNumber(), block.getReceiverOutputDate(), block.getReceiverOutputTime(), block.getMessagePriority());
    }

    public static SwiftBlock2Output fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (SwiftBlock2Output)gson.fromJson(json, SwiftBlock2Output.class);
    }

    public String getSenderInputTime() {
        return this.senderInputTime;
    }

    public void setSenderInputTime(String senderInputTime) {
        this.senderInputTime = senderInputTime;
    }

    public String getMIRDate() {
        return this.MIRDate;
    }

    public void setMIRDate(String MIRDate) {
        this.MIRDate = MIRDate;
    }

    public void setMIRDate(Calendar cal) {
        String yymmdd = DateFormatUtils.format((Date)cal.getTime(), (String)"yyMMdd");
        this.setMIRDate(yymmdd);
    }

    public void setSender(BIC bic) {
        this.setMIRLogicalTerminal(new LogicalTerminalAddress(bic.getBic11()));
    }

    public void setSender(String sender) {
        this.setMIRLogicalTerminal(new LogicalTerminalAddress(sender));
    }

    public String getMIRLogicalTerminal() {
        return this.MIRLogicalTerminal;
    }

    public void setMIRLogicalTerminal(String MIRLogicalTerminal) {
        this.MIRLogicalTerminal = MIRLogicalTerminal;
    }

    public void setMIRLogicalTerminal(LogicalTerminalAddress MIRLogicalTerminal) {
        this.MIRLogicalTerminal = MIRLogicalTerminal.getSenderLogicalTerminalAddress();
    }

    public BIC getSenderBIC() {
        return new BIC(this.MIRLogicalTerminal);
    }

    public String getMIRSessionNumber() {
        return this.MIRSessionNumber;
    }

    public void setMIRSessionNumber(String MIRSessionNumber) {
        this.MIRSessionNumber = MIRSessionNumber;
    }

    public String getMIRSequenceNumber() {
        return this.MIRSequenceNumber;
    }

    public void setMIRSequenceNumber(String MIRSequenceNumber) {
        this.MIRSequenceNumber = MIRSequenceNumber;
    }

    public String getMIR() {
        if (this.MIRDate == null && this.MIRLogicalTerminal == null && this.MIRSessionNumber == null && this.MIRSequenceNumber == null) {
            return null;
        }
        StringBuilder v = new StringBuilder();
        if (this.MIRDate != null) {
            v.append(this.MIRDate);
        }
        if (this.MIRLogicalTerminal != null) {
            v.append(this.MIRLogicalTerminal);
        }
        if (this.MIRSessionNumber != null) {
            v.append(this.MIRSessionNumber);
        }
        if (this.MIRSequenceNumber != null) {
            v.append(this.MIRSequenceNumber);
        }
        return v.toString();
    }

    public void setMIR(String mir) {
        this.setMIR(mir, false);
    }

    public void setMIR(String mir, boolean lenient) {
        if (!lenient) {
            Validate.notNull((Object)mir);
            if (mir != null) {
                Validate.isTrue((mir.length() == 28 ? 1 : 0) != 0, (String)("expected a 28 characters string for MIR value and found a " + mir.length() + " string:" + mir), (Object[])new Object[0]);
            }
        }
        if (mir != null) {
            int offset = 0;
            int len = 6;
            this.setMIRDate(this.getValuePart(mir, offset, len));
            offset += len;
            len = 12;
            this.setMIRLogicalTerminal(this.getValuePart(mir, offset, len));
            offset += len;
            len = 4;
            this.setMIRSessionNumber(this.getValuePart(mir, offset, len));
            offset += len;
            if (lenient) {
                this.setMIRSequenceNumber(this.getValuePart(mir, offset, mir.length()));
            } else {
                len = 6;
                this.setMIRSequenceNumber(this.getValuePart(mir, offset, len));
            }
        }
    }

    public String getReceiverOutputDate() {
        return this.receiverOutputDate;
    }

    public void setReceiverOutputDate(String receiverOutputDate) {
        this.receiverOutputDate = receiverOutputDate;
    }

    public String getReceiverOutputTime() {
        return this.receiverOutputTime;
    }

    public void setReceiverOutputTime(String receiverOutputTime) {
        this.receiverOutputTime = receiverOutputTime;
    }

    public void setReceiverOutputDateTime(Calendar cal) {
        String yymmdd = DateFormatUtils.format((Date)cal.getTime(), (String)"yyMMdd");
        String hhmm = DateFormatUtils.format((Date)cal.getTime(), (String)"HHmm");
        this.setReceiverOutputDate(yymmdd);
        this.setReceiverOutputTime(hhmm);
    }

    @Override
    public boolean isEmpty() {
        return this.messageType == null && this.senderInputTime == null && this.getMIR() == null && this.receiverOutputDate == null && this.receiverOutputTime == null && this.messagePriority == null;
    }

    @Override
    public String getValue() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuilder v = new StringBuilder("O");
        if (this.messageType != null) {
            v.append(this.messageType);
        }
        if (this.senderInputTime != null) {
            v.append(this.senderInputTime);
        }
        if (this.getMIR() != null) {
            v.append(this.getMIR());
        }
        if (this.receiverOutputDate != null) {
            v.append(this.receiverOutputDate);
        }
        if (this.receiverOutputTime != null) {
            v.append(this.receiverOutputTime);
        }
        if (this.messagePriority != null) {
            v.append(this.messagePriority);
        }
        return v.toString();
    }

    @Override
    public void setValue(String value) {
        this.setValue(value, false);
    }

    @Override
    public String getBlockValue() {
        return this.getValue();
    }

    @Override
    public void setBlockValue(String value) {
        this.setValue(value);
    }

    public void setValue(String value, boolean lenient) {
        if (lenient) {
            this.clean();
        } else {
            Validate.notNull((Object)value, (String)"value must not be null", (Object[])new Object[0]);
        }
        if (value != null) {
            int slen = value.length();
            if (!lenient) {
                Validate.notNull((Object)value, (String)"value must not be null", (Object[])new Object[0]);
                Validate.isTrue((slen == 46 || slen == 48 || slen == 47 || slen == 49 ? 1 : 0) != 0, (String)("expected a string value of 46 and up to 49 chars and obtained a " + slen + " chars string: '" + value + "'"), (Object[])new Object[0]);
            }
            int offset = 0;
            if (value.startsWith("2:")) {
                offset = 2;
            }
            if (!lenient && (slen -= offset) != 46 && slen != 47) {
                throw new IllegalArgumentException("Value must match: O<mt><time><mir><date><time>[<pri>]");
            }
            int len = 3;
            this.setMessageType(this.getValuePart(value, ++offset, len));
            offset += len;
            len = 4;
            this.setSenderInputTime(this.getValuePart(value, offset, len));
            offset += len;
            len = 28;
            this.setMIR(this.getValuePart(value, offset, len), lenient);
            offset += len;
            len = 6;
            this.setReceiverOutputDate(this.getValuePart(value, offset, len));
            offset += len;
            len = 4;
            this.setReceiverOutputTime(this.getValuePart(value, offset, len));
            offset += len;
            if (lenient) {
                this.setMessagePriority(this.getValuePart(value, offset));
            } else {
                len = 1;
                this.setMessagePriority(this.getValuePart(value, offset, len));
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SwiftBlock2Output that = (SwiftBlock2Output)o;
        return Objects.equals(this.senderInputTime, that.senderInputTime) && Objects.equals(this.MIRDate, that.MIRDate) && Objects.equals(this.MIRLogicalTerminal, that.MIRLogicalTerminal) && Objects.equals(this.MIRSessionNumber, that.MIRSessionNumber) && Objects.equals(this.MIRSequenceNumber, that.MIRSequenceNumber) && Objects.equals(this.receiverOutputDate, that.receiverOutputDate) && Objects.equals(this.receiverOutputTime, that.receiverOutputTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.senderInputTime, this.MIRDate, this.MIRLogicalTerminal, this.MIRSessionNumber, this.MIRSequenceNumber, this.receiverOutputDate, this.receiverOutputTime);
    }

    public String field(SwiftBlock2OutputField field) {
        switch (field) {
            case Direction: {
                return MessageDirection.Output.name();
            }
            case MessageType: {
                return this.getMessageType();
            }
            case MessagePriority: {
                return this.getMessagePriority();
            }
            case SenderInputTime: {
                return this.getSenderInputTime();
            }
            case MIRDate: {
                return this.getMIRDate();
            }
            case MIRLogicalTerminal: {
                return this.getMIRLogicalTerminal();
            }
            case MIRSessionNumber: {
                return this.getMIRSessionNumber();
            }
            case MIRSequenceNumber: {
                return this.getMIRSequenceNumber();
            }
            case ReceiverOutputDate: {
                return this.getReceiverOutputDate();
            }
            case ReceiverOutputTime: {
                return this.getReceiverOutputTime();
            }
        }
        return null;
    }

    public void setField(SwiftBlock2OutputField field, String value) {
        switch (field) {
            case MessageType: {
                this.setMessageType(value);
                break;
            }
            case MessagePriority: {
                this.setMessagePriority(value);
                break;
            }
            case SenderInputTime: {
                this.setSenderInputTime(value);
                break;
            }
            case MIRDate: {
                this.setMIRDate(value);
                break;
            }
            case MIRLogicalTerminal: {
                this.setMIRLogicalTerminal(value);
                break;
            }
            case MIRSessionNumber: {
                this.setMIRSessionNumber(value);
                break;
            }
            case MIRSequenceNumber: {
                this.setMIRSequenceNumber(value);
                break;
            }
            case ReceiverOutputDate: {
                this.setReceiverOutputDate(value);
                break;
            }
            case ReceiverOutputTime: {
                this.setReceiverOutputTime(value);
                break;
            }
        }
    }
}

