/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.ResolverUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class CurrencyResolver {
    public static List<String> currencyStrings(Field f) {
        Validate.notNull((Object)f);
        return ResolverUtils.findWantedType(f.typesPattern(), 'C', f.getComponents());
    }

    @Deprecated
    public static List<String> resolveComponentsPattern(String pattern, List<String> components) {
        return ResolverUtils.findWantedType(pattern, 'C', components);
    }

    public static List<Currency> currencies(Field f) {
        Validate.notNull((Object)f);
        List<String> values = ResolverUtils.findWantedType(f.typesPattern(), 'C', f.getComponents());
        ArrayList<Currency> currencies = new ArrayList<Currency>();
        for (String value : values) {
            currencies.add(SwiftFormatUtils.getCurrency(value));
        }
        return currencies;
    }

    public static Currency resolveCurrency(CurrencyContainer o) {
        List<Currency> currencies = o.currencies();
        return currencies != null && !currencies.isEmpty() ? currencies.get(0) : null;
    }

    public static String resolveCurrencyString(CurrencyContainer o) {
        List<String> currencies = o.currencyStrings();
        return currencies != null && !currencies.isEmpty() ? currencies.get(0) : null;
    }

    public static void resolveSetCurrency(CurrencyContainer cc, Currency cur) {
        CurrencyResolver.resolveSetCurrency(cc, cur.toString());
    }

    public static void resolveSetCurrency(CurrencyContainer cc, String cur) {
        if (cc instanceof Field) {
            Field f = (Field)((Object)cc);
            List<Integer> positions = ResolverUtils.findWantedTypesPosition(f.typesPattern(), 'C');
            for (Integer position : positions) {
                f.setComponent(position, cur);
            }
        }
    }
}

