/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field33S
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "33S";
    public static final String F_33S = "33S";
    public static final String PARSER_PATTERN = "SN";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SN";
    public static final String TYPES_PATTERN = "SI";
    public static final Integer CODE = 1;
    @Deprecated
    public static final Integer CURRENCY = 1;
    public static final Integer AMOUNT = 2;

    public Field33S() {
        super(2);
    }

    public Field33S(String value) {
        super(value);
    }

    public Field33S(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"33S")) {
            throw new IllegalArgumentException("cannot create field 33S from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field33S newInstance(Field33S source) {
        Field33S cp = new Field33S();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("33S", value);
    }

    public static Tag emptyTag() {
        return new Tag("33S", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 33S");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent2AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        return "SN";
    }

    @Override
    public final String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return "SN";
    }

    @Override
    public final String validatorPattern() {
        return "3!a<AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Code");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "code");
        result.put(2, "amount");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getCode() {
        return this.getComponent1();
    }

    @Deprecated
    public String getCurrency() {
        return this.getCode();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BigDecimal getComponent2AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        return this.getComponent2AsBigDecimal();
    }

    public String getAmount() {
        return this.getComponent2();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent2AsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getComponent2AsNumber();
    }

    public Field33S setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field33S setCode(String component1) {
        return this.setComponent1(component1);
    }

    @Deprecated
    public Field33S setCurrency(String component1) {
        return this.setCode(component1);
    }

    public Field33S setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field33S setComponent2(BigDecimal component2) {
        this.setComponent(2, SwiftFormatUtils.getBigDecimal(component2));
        return this;
    }

    public Field33S setComponent2(Number component2) {
        if (component2 instanceof BigDecimal) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal((BigDecimal)component2));
        } else if (component2 instanceof BigInteger) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component2)));
        } else if (component2 instanceof Long || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.longValue())));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.doubleValue())));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field33S setAmount(String component2) {
        return this.setComponent2(component2);
    }

    public Field33S setAmount(BigDecimal component2) {
        return this.setComponent2(component2);
    }

    public Field33S setAmount(Number component2) {
        return this.setComponent2(component2);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "33S";
    }

    public static Field33S get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("33S");
        if (t == null) {
            return null;
        }
        return new Field33S(t);
    }

    public static Field33S get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field33S.get(msg.getBlock4());
    }

    public static List<Field33S> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field33S.getAll(msg.getBlock4());
    }

    public static List<Field33S> getAll(SwiftTagListBlock block) {
        ArrayList<Field33S> result = new ArrayList<Field33S>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("33S");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field33S(f));
            }
        }
        return result;
    }

    public static Field33S fromJson(String json) {
        Field33S field = new Field33S();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("currency") != null) {
            field.setComponent1(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent1(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent2(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

