/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field38H
extends Field
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "38H";
    public static final String F_38H = "38H";
    public static final String PARSER_PATTERN = "NS/NS";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "NSNS";
    public static final String TYPES_PATTERN = "NSNS";
    public static final Integer NUMBER_FROM = 1;
    public static final Integer PERIOD_FROM = 2;
    public static final Integer NUMBER_TO = 3;
    public static final Integer PERIOD_TO = 4;

    public Field38H() {
        super(4);
    }

    public Field38H(String value) {
        super(value);
    }

    public Field38H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"38H")) {
            throw new IllegalArgumentException("cannot create field 38H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field38H newInstance(Field38H source) {
        Field38H cp = new Field38H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("38H", value);
    }

    public static Tag emptyTag() {
        return new Tag("38H", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getNumericPrefix(StringUtils.substringBefore((String)value, (String)"/")));
        this.setComponent2(SwiftParseUtils.getAlphaSuffix(StringUtils.substringBefore((String)value, (String)"/")));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "/");
        this.setComponent3(SwiftParseUtils.getNumericPrefix(toparse));
        this.setComponent4(SwiftParseUtils.getAlphaSuffix(toparse));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 38H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        return "NSNS";
    }

    @Override
    public final String typesPattern() {
        return "NSNS";
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "2n1a/2n1a";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Number From");
        result.add("Period From");
        result.add("Number To");
        result.add("Period To");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "numberFrom");
        result.put(2, "periodFrom");
        result.put(3, "numberTo");
        result.put(4, "periodTo");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    @Deprecated
    public Number getComponent1AsNumber() {
        Long l = this.getComponent1AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getNumberFrom() {
        return this.getComponent1();
    }

    public Long getNumberFromAsLong() {
        return this.getComponent1AsLong();
    }

    @Deprecated
    public Number getNumberFromAsNumber() {
        return this.getComponent1AsNumber();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getPeriodFrom() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Long getComponent3AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(3));
    }

    @Deprecated
    public Number getComponent3AsNumber() {
        Long l = this.getComponent3AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getNumberTo() {
        return this.getComponent3();
    }

    public Long getNumberToAsLong() {
        return this.getComponent3AsLong();
    }

    @Deprecated
    public Number getNumberToAsNumber() {
        return this.getComponent3AsNumber();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getPeriodTo() {
        return this.getComponent4();
    }

    public Field38H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field38H setComponent1(Long component1) {
        this.setComponent(1, SwiftFormatUtils.getLong(component1));
        return this;
    }

    public Field38H setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field38H setNumberFrom(String component1) {
        return this.setComponent1(component1);
    }

    public Field38H setNumberFrom(Long component1) {
        return this.setComponent1(component1);
    }

    public Field38H setNumberFrom(Number component1) {
        return this.setComponent1(component1);
    }

    public Field38H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field38H setPeriodFrom(String component2) {
        return this.setComponent2(component2);
    }

    public Field38H setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field38H setComponent3(Long component3) {
        this.setComponent(3, SwiftFormatUtils.getLong(component3));
        return this;
    }

    public Field38H setComponent3(Number component3) {
        if (component3 instanceof Long) {
            this.setComponent(3, SwiftFormatUtils.getLong((Long)component3));
        } else if (component3 instanceof BigInteger || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field38H setNumberTo(String component3) {
        return this.setComponent3(component3);
    }

    public Field38H setNumberTo(Long component3) {
        return this.setComponent3(component3);
    }

    public Field38H setNumberTo(Number component3) {
        return this.setComponent3(component3);
    }

    public Field38H setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field38H setPeriodTo(String component4) {
        return this.setComponent4(component4);
    }

    @Override
    public String getName() {
        return "38H";
    }

    public static Field38H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("38H");
        if (t == null) {
            return null;
        }
        return new Field38H(t);
    }

    public static Field38H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field38H.get(msg.getBlock4());
    }

    public static List<Field38H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field38H.getAll(msg.getBlock4());
    }

    public static List<Field38H> getAll(SwiftTagListBlock block) {
        ArrayList<Field38H> result = new ArrayList<Field38H>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("38H");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field38H(f));
            }
        }
        return result;
    }

    public static Field38H fromJson(String json) {
        Field38H field = new Field38H();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("numberFrom") != null) {
            field.setComponent1(jsonObject.get("numberFrom").getAsString());
        }
        if (jsonObject.get("periodFrom") != null) {
            field.setComponent2(jsonObject.get("periodFrom").getAsString());
        }
        if (jsonObject.get("numberTo") != null) {
            field.setComponent3(jsonObject.get("numberTo").getAsString());
        }
        if (jsonObject.get("periodTo") != null) {
            field.setComponent4(jsonObject.get("periodTo").getAsString());
        }
        return field;
    }
}

