/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field71F
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "71F";
    public static final String F_71F = "71F";
    public static final String PARSER_PATTERN = "SN";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "CN";
    public static final String TYPES_PATTERN = "CI";
    public static final Integer CURRENCY = 1;
    public static final Integer AMOUNT = 2;

    public Field71F() {
        super(2);
    }

    public Field71F(String value) {
        super(value);
    }

    public Field71F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"71F")) {
            throw new IllegalArgumentException("cannot create field 71F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field71F newInstance(Field71F source) {
        Field71F cp = new Field71F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("71F", value);
    }

    public static Tag emptyTag() {
        return new Tag("71F", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 71F");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent2AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Currency");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "currency");
        result.put(2, "amount");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Currency getComponent1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public String getCurrency() {
        return this.getComponent1();
    }

    public Currency getCurrencyAsCurrency() {
        return this.getComponent1AsCurrency();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BigDecimal getComponent2AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        return this.getComponent2AsBigDecimal();
    }

    public String getAmount() {
        return this.getComponent2();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent2AsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getComponent2AsNumber();
    }

    public Field71F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field71F setComponent1(Currency component1) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(component1));
        return this;
    }

    public Field71F setCurrency(String component1) {
        return this.setComponent1(component1);
    }

    public Field71F setCurrency(Currency component1) {
        return this.setComponent1(component1);
    }

    public Field71F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field71F setComponent2(BigDecimal component2) {
        this.setComponent(2, SwiftFormatUtils.getBigDecimal(component2));
        return this;
    }

    public Field71F setComponent2(Number component2) {
        if (component2 instanceof BigDecimal) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal((BigDecimal)component2));
        } else if (component2 instanceof BigInteger) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component2)));
        } else if (component2 instanceof Long || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.longValue())));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.doubleValue())));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field71F setAmount(String component2) {
        return this.setComponent2(component2);
    }

    public Field71F setAmount(BigDecimal component2) {
        return this.setComponent2(component2);
    }

    public Field71F setAmount(Number component2) {
        return this.setComponent2(component2);
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return CurrencyResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "71F";
    }

    public static Field71F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("71F");
        if (t == null) {
            return null;
        }
        return new Field71F(t);
    }

    public static Field71F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field71F.get(msg.getBlock4());
    }

    public static List<Field71F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field71F.getAll(msg.getBlock4());
    }

    public static List<Field71F> getAll(SwiftTagListBlock block) {
        ArrayList<Field71F> result = new ArrayList<Field71F>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("71F");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field71F(f));
            }
        }
        return result;
    }

    public static Field71F fromJson(String json) {
        Field71F field = new Field71F();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("currency") != null) {
            field.setComponent1(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent2(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

