/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field92H
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer,
GenericField {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "92H";
    public static final String F_92H = "92H";
    public static final String PARSER_PATTERN = ":S//SN/S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SCNS";
    public static final String TYPES_PATTERN = "SCIS";
    public static final Integer QUALIFIER = 1;
    public static final Integer CURRENCY_CODE = 2;
    @Deprecated
    public static final Integer CURRENCY = 2;
    public static final Integer AMOUNT = 3;
    public static final Integer RATE_STATUS = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 4;

    public Field92H() {
        super(4);
    }

    public Field92H(String value) {
        super(value);
    }

    public Field92H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"92H")) {
            throw new IllegalArgumentException("cannot create field 92H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field92H newInstance(Field92H source) {
        Field92H cp = new Field92H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("92H", value);
    }

    public static Tag emptyTag() {
        return new Tag("92H", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        String toparse2 = SwiftParseUtils.getTokenFirst(toparse, "/");
        this.setComponent4(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
        this.setComponent2(SwiftParseUtils.getAlphaPrefixTrimSlash(toparse2));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse2));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 92H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent3AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<CUR><AMOUNT>15/4!c";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Currency Code");
        result.add("Amount");
        result.add("Rate Status");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "currencyCode");
        result.put(3, "amount");
        result.put(4, "rateStatus");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrencyCode() {
        return this.getComponent2();
    }

    @Deprecated
    public String getCurrency() {
        return this.getCurrencyCode();
    }

    public Currency getCurrencyCodeAsCurrency() {
        return this.getComponent2AsCurrency();
    }

    @Deprecated
    public Currency getCurrencyAsCurrency() {
        return this.getCurrencyCodeAsCurrency();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BigDecimal getComponent3AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(3));
    }

    @Deprecated
    public Number getComponent3AsNumber() {
        return this.getComponent3AsBigDecimal();
    }

    public String getAmount() {
        return this.getComponent3();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent3AsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getComponent3AsNumber();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getRateStatus() {
        return this.getComponent4();
    }

    public Field92H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field92H setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field92H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92H setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field92H setCurrencyCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field92H setCurrencyCode(Currency component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field92H setCurrency(String component2) {
        return this.setCurrencyCode(component2);
    }

    @Deprecated
    public Field92H setCurrency(Currency component2) {
        return this.setCurrencyCode(component2);
    }

    public Field92H setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field92H setComponent3(BigDecimal component3) {
        this.setComponent(3, SwiftFormatUtils.getBigDecimal(component3));
        return this;
    }

    public Field92H setComponent3(Number component3) {
        if (component3 instanceof BigDecimal) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal((BigDecimal)component3));
        } else if (component3 instanceof BigInteger) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component3)));
        } else if (component3 instanceof Long || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.longValue())));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.doubleValue())));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field92H setAmount(String component3) {
        return this.setComponent3(component3);
    }

    public Field92H setAmount(BigDecimal component3) {
        return this.setComponent3(component3);
    }

    public Field92H setAmount(Number component3) {
        return this.setComponent3(component3);
    }

    public Field92H setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field92H setRateStatus(String component4) {
        return this.setComponent4(component4);
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return CurrencyResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "92H";
    }

    public static Field92H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("92H");
        if (t == null) {
            return null;
        }
        return new Field92H(t);
    }

    public static Field92H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field92H.get(msg.getBlock4());
    }

    public static List<Field92H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field92H.getAll(msg.getBlock4());
    }

    public static List<Field92H> getAll(SwiftTagListBlock block) {
        ArrayList<Field92H> result = new ArrayList<Field92H>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("92H");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field92H(f));
            }
        }
        return result;
    }

    public static Field92H fromJson(String json) {
        Field92H field = new Field92H();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent2(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("currencyCode") != null) {
            field.setComponent2(jsonObject.get("currencyCode").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent3(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("rateStatus") != null) {
            field.setComponent4(jsonObject.get("rateStatus").getAsString());
        }
        return field;
    }
}

