/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field93B
extends Field
implements Serializable,
AmountContainer,
GenericField {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "93B";
    public static final String F_93B = "93B";
    public static final String PARSER_PATTERN = ":S/[S]/S/[S]N";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSSSN";
    public static final String TYPES_PATTERN = "SSSSI";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATA_SOURCE_SCHEME = 2;
    public static final Integer QUANTITY_TYPE_CODE = 3;
    public static final Integer SIGN = 4;
    public static final Integer BALANCE = 5;
    @Deprecated
    public static final Integer BALANCE_AMOUNT = 5;
    public static final Integer CONDITIONAL_QUALIFIER = 3;

    public Field93B() {
        super(5);
    }

    public Field93B(String value) {
        super(value);
    }

    public Field93B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"93B")) {
            throw new IllegalArgumentException("cannot create field 93B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field93B newInstance(Field93B source) {
        Field93B cp = new Field93B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("93B", value);
    }

    public static Tag emptyTag() {
        return new Tag("93B", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
        String toparse = SwiftParseUtils.getTokenThirdLast(value, "/");
        this.setComponent3(SwiftParseUtils.getTokenFirst(toparse, null, "/"));
        String toparse2 = SwiftParseUtils.getTokenSecondLast(toparse, "/");
        this.setComponent4(SwiftParseUtils.getAlphaPrefixTrimSlash(toparse2));
        this.setComponent5(SwiftParseUtils.getNumericSuffix(toparse2));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        this.append(result, 5);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 93B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent5AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c/[8c]/4!c/[<N>]<AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Data Source Scheme");
        result.add("Quantity Type Code");
        result.add("Sign");
        result.add("Balance");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "dataSourceScheme");
        result.put(3, "quantityTypeCode");
        result.put(4, "sign");
        result.put(5, "balance");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getQuantityTypeCode() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getSign() {
        return this.getComponent4();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public BigDecimal getComponent5AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(5));
    }

    @Deprecated
    public Number getComponent5AsNumber() {
        return this.getComponent5AsBigDecimal();
    }

    public String getBalance() {
        return this.getComponent5();
    }

    @Deprecated
    public String getBalanceAmount() {
        return this.getBalance();
    }

    public BigDecimal getBalanceAsBigDecimal() {
        return this.getComponent5AsBigDecimal();
    }

    @Deprecated
    public Number getBalanceAsNumber() {
        return this.getComponent5AsNumber();
    }

    @Deprecated
    public BigDecimal getBalanceAmountAsBigDecimal() {
        return this.getBalanceAsBigDecimal();
    }

    @Deprecated
    public Number getBalanceAmountAsNumber() {
        return this.getBalanceAsNumber();
    }

    public Field93B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field93B setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field93B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field93B setDataSourceScheme(String component2) {
        return this.setComponent2(component2);
    }

    public Field93B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field93B setQuantityTypeCode(String component3) {
        return this.setComponent3(component3);
    }

    public Field93B setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field93B setSign(String component4) {
        return this.setComponent4(component4);
    }

    public Field93B setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field93B setComponent5(BigDecimal component5) {
        this.setComponent(5, SwiftFormatUtils.getBigDecimal(component5));
        return this;
    }

    public Field93B setComponent5(Number component5) {
        if (component5 instanceof BigDecimal) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal((BigDecimal)component5));
        } else if (component5 instanceof BigInteger) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component5)));
        } else if (component5 instanceof Long || component5 instanceof Integer) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component5.longValue())));
        } else if (component5 != null) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component5.doubleValue())));
        } else {
            this.setComponent(5, null);
        }
        return this;
    }

    public Field93B setBalance(String component5) {
        return this.setComponent5(component5);
    }

    public Field93B setBalance(BigDecimal component5) {
        return this.setComponent5(component5);
    }

    public Field93B setBalance(Number component5) {
        return this.setComponent5(component5);
    }

    @Deprecated
    public Field93B setBalanceAmount(String component5) {
        return this.setBalance(component5);
    }

    @Deprecated
    public Field93B setBalanceAmount(BigDecimal component5) {
        return this.setBalance(component5);
    }

    @Deprecated
    public Field93B setBalanceAmount(Number component5) {
        return this.setBalance(component5);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return this.getComponent2();
    }

    @Override
    public boolean isDSSPresent() {
        return this.getComponent2() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "93B";
    }

    public static Field93B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("93B");
        if (t == null) {
            return null;
        }
        return new Field93B(t);
    }

    public static Field93B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field93B.get(msg.getBlock4());
    }

    public static List<Field93B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field93B.getAll(msg.getBlock4());
    }

    public static List<Field93B> getAll(SwiftTagListBlock block) {
        ArrayList<Field93B> result = new ArrayList<Field93B>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("93B");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field93B(f));
            }
        }
        return result;
    }

    public static Field93B fromJson(String json) {
        Field93B field = new Field93B();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("dataSourceScheme") != null) {
            field.setComponent2(jsonObject.get("dataSourceScheme").getAsString());
        }
        if (jsonObject.get("quantityTypeCode") != null) {
            field.setComponent3(jsonObject.get("quantityTypeCode").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent4(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("balanceAmount") != null) {
            field.setComponent5(jsonObject.get("balanceAmount").getAsString());
        }
        if (jsonObject.get("balance") != null) {
            field.setComponent5(jsonObject.get("balance").getAsString());
        }
        return field;
    }
}

