/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field33A;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field53D;
import com.prowidesoftware.swift.model.field.Field54A;
import com.prowidesoftware.swift.model.field.Field54B;
import com.prowidesoftware.swift.model.field.Field54D;
import com.prowidesoftware.swift.model.field.Field72Z;
import com.prowidesoftware.swift.model.field.Field79Z;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT756
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT756.class.getName());
    public static final String NAME = "756";

    public MT756(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT756(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT756 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT756(m);
    }

    public MT756() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT756(String sender, String receiver) {
        super(756, sender, receiver);
    }

    public MT756(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT756.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT756 object from FIN content with a Service Message. Check if the MT756 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT756 object from FIN content with message type " + param.getType());
        }
    }

    public static MT756 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT756(fin);
    }

    public MT756(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT756 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT756(stream);
    }

    public MT756(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT756 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT756(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT756 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT756 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT756 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT756 fromJson(String json) {
        return (MT756)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field32B getField32B() {
        Tag t = this.tag("32B");
        if (t != null) {
            return new Field32B(t.getValue());
        }
        return null;
    }

    public Field33A getField33A() {
        Tag t = this.tag("33A");
        if (t != null) {
            return new Field33A(t.getValue());
        }
        return null;
    }

    public Field53A getField53A() {
        Tag t = this.tag("53A");
        if (t != null) {
            return new Field53A(t.getValue());
        }
        return null;
    }

    public Field53B getField53B() {
        Tag t = this.tag("53B");
        if (t != null) {
            return new Field53B(t.getValue());
        }
        return null;
    }

    public Field53D getField53D() {
        Tag t = this.tag("53D");
        if (t != null) {
            return new Field53D(t.getValue());
        }
        return null;
    }

    public Field54A getField54A() {
        Tag t = this.tag("54A");
        if (t != null) {
            return new Field54A(t.getValue());
        }
        return null;
    }

    public Field54B getField54B() {
        Tag t = this.tag("54B");
        if (t != null) {
            return new Field54B(t.getValue());
        }
        return null;
    }

    public Field54D getField54D() {
        Tag t = this.tag("54D");
        if (t != null) {
            return new Field54D(t.getValue());
        }
        return null;
    }

    public Field72Z getField72Z() {
        Tag t = this.tag("72Z");
        if (t != null) {
            return new Field72Z(t.getValue());
        }
        return null;
    }

    public Field79Z getField79Z() {
        Tag t = this.tag("79Z");
        if (t != null) {
            return new Field79Z(t.getValue());
        }
        return null;
    }
}

