/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field27;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field77L;
import com.prowidesoftware.swift.model.field.Field77U;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT761
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT761.class.getName());
    public static final String NAME = "761";

    public MT761(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT761(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT761 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT761(m);
    }

    public MT761() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT761(String sender, String receiver) {
        super(761, sender, receiver);
    }

    public MT761(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT761.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT761 object from FIN content with a Service Message. Check if the MT761 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT761 object from FIN content with message type " + param.getType());
        }
    }

    public static MT761 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT761(fin);
    }

    public MT761(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT761 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT761(stream);
    }

    public MT761(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT761 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT761(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT761 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT761 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT761 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT761 fromJson(String json) {
        return (MT761)AbstractMT.fromJson(json);
    }

    public Field27 getField27() {
        Tag t = this.tag("27");
        if (t != null) {
            return new Field27(t.getValue());
        }
        return null;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field77U getField77U() {
        Tag t = this.tag("77U");
        if (t != null) {
            return new Field77U(t.getValue());
        }
        return null;
    }

    public Field77L getField77L() {
        Tag t = this.tag("77L");
        if (t != null) {
            return new Field77L(t.getValue());
        }
        return null;
    }
}

