/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field32G
extends Field
implements Serializable,
MonetaryAmountContainer {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "32G";
    public static final String F_32G = "32G";
    @Deprecated
    public static final String PARSER_PATTERN = "SN";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "CN";
    @Deprecated
    public static final String TYPES_PATTERN = "CI";
    public static final Integer CURRENCY = 1;
    public static final Integer AMOUNT = 2;

    public Field32G() {
        super(2);
    }

    public Field32G(String value) {
        super(value);
    }

    public Field32G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"32G")) {
            throw new IllegalArgumentException("cannot create field 32G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field32G newInstance(Field32G source) {
        Field32G cp = new Field32G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("32G", value);
    }

    public static Tag emptyTag() {
        return new Tag("32G", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 32G");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent2AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Currency");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "currency");
        result.put(2, "amount");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Currency getComponent1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public String getCurrency() {
        return this.getComponent1();
    }

    public Currency getCurrencyAsCurrency() {
        return this.getComponent1AsCurrency();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BigDecimal getComponent2AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        return this.getComponent2AsBigDecimal();
    }

    public String getAmount() {
        return this.getComponent2();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent2AsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getComponent2AsNumber();
    }

    public Field32G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field32G setComponent1(Currency component1) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(component1));
        return this;
    }

    public Field32G setCurrency(String component1) {
        return this.setComponent1(component1);
    }

    public Field32G setCurrency(Currency component1) {
        return this.setComponent1(component1);
    }

    public Field32G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field32G setComponent2(BigDecimal component2) {
        this.setComponent(2, SwiftFormatUtils.getBigDecimal(component2));
        return this;
    }

    public Field32G setComponent2(Number component2) {
        if (component2 instanceof BigDecimal) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal((BigDecimal)component2));
        } else if (component2 instanceof BigInteger) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component2)));
        } else if (component2 instanceof Long || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.longValue())));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.doubleValue())));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field32G setAmount(String component2) {
        return this.setComponent2(component2);
    }

    public Field32G setAmount(BigDecimal component2) {
        return this.setComponent2(component2);
    }

    public Field32G setAmount(Number component2) {
        return this.setComponent2(component2);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "32G";
    }

    public static Field32G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("32G");
        if (t == null) {
            return null;
        }
        return new Field32G(t);
    }

    public static Field32G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field32G.get(msg.getBlock4());
    }

    public static List<Field32G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field32G.getAll(msg.getBlock4());
    }

    public static List<Field32G> getAll(SwiftTagListBlock block) {
        ArrayList<Field32G> result = new ArrayList<Field32G>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("32G");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field32G(f));
            }
        }
        return result;
    }

    public static Field32G fromJson(String json) {
        Field32G field = new Field32G();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("currency") != null) {
            field.setComponent1(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent2(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

