/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field177;
import com.prowidesoftware.swift.model.field.Field305;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT036
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT036.class.getName());
    public static final String NAME = "036";

    public MT036(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT036(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT036 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT036(m);
    }

    public MT036() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT036(String sender, String receiver) {
        super(36, sender, receiver);
    }

    public MT036(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT036.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT036 object from FIN content with a Service Message. Check if the MT036 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT036 object from FIN content with message type " + param.getType());
        }
    }

    public static MT036 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT036(fin);
    }

    public MT036(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT036 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT036(stream);
    }

    public MT036(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT036 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT036(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT036 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT036 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT036 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT036 fromJson(String json) {
        return (MT036)AbstractMT.fromJson(json);
    }

    public Field305 getField305() {
        Tag t = this.tag("305");
        if (t != null) {
            return new Field305(t.getValue());
        }
        return null;
    }

    public List<Field177> getField177() {
        ArrayList<Field177> result = new ArrayList<Field177>();
        Tag[] tags = this.tags("177");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field177(tag.getValue()));
            }
        }
        return result;
    }
}

