/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field301;
import com.prowidesoftware.swift.model.field.Field303;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT046
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT046.class.getName());
    public static final String NAME = "046";

    public MT046(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT046(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT046 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT046(m);
    }

    public MT046() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT046(String sender, String receiver) {
        super(46, sender, receiver);
    }

    public MT046(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT046.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT046 object from FIN content with a Service Message. Check if the MT046 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT046 object from FIN content with message type " + param.getType());
        }
    }

    public static MT046 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT046(fin);
    }

    public MT046(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT046 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT046(stream);
    }

    public MT046(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT046 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT046(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT046 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT046 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT046 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT046 fromJson(String json) {
        return (MT046)AbstractMT.fromJson(json);
    }

    public Field303 getField303() {
        Tag t = this.tag("303");
        if (t != null) {
            return new Field303(t.getValue());
        }
        return null;
    }

    public Field301 getField301() {
        Tag t = this.tag("301");
        if (t != null) {
            return new Field301(t.getValue());
        }
        return null;
    }
}

