/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt2xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field50;
import com.prowidesoftware.swift.model.field.Field50C;
import com.prowidesoftware.swift.model.field.Field50F;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field56A;
import com.prowidesoftware.swift.model.field.Field56D;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT210
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT210.class.getName());
    public static final String NAME = "210";

    public MT210(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT210(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT210 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT210(m);
    }

    public MT210() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT210(String sender, String receiver) {
        super(210, sender, receiver);
    }

    public MT210(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT210.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT210 object from FIN content with a Service Message. Check if the MT210 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT210 object from FIN content with message type " + param.getType());
        }
    }

    public static MT210 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT210(fin);
    }

    public MT210(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT210 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT210(stream);
    }

    public MT210(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT210 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT210(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT210 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT210 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT210 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT210 fromJson(String json) {
        return (MT210)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field21(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field50C> getField50C() {
        ArrayList<Field50C> result = new ArrayList<Field50C>();
        Tag[] tags = this.tags("50C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field50C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field50F> getField50F() {
        ArrayList<Field50F> result = new ArrayList<Field50F>();
        Tag[] tags = this.tags("50F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field50F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field50> getField50() {
        ArrayList<Field50> result = new ArrayList<Field50>();
        Tag[] tags = this.tags("50");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field50(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field52A> getField52A() {
        ArrayList<Field52A> result = new ArrayList<Field52A>();
        Tag[] tags = this.tags("52A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field52A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field52D> getField52D() {
        ArrayList<Field52D> result = new ArrayList<Field52D>();
        Tag[] tags = this.tags("52D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field52D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field56A> getField56A() {
        ArrayList<Field56A> result = new ArrayList<Field56A>();
        Tag[] tags = this.tags("56A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field56A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field56D> getField56D() {
        ArrayList<Field56D> result = new ArrayList<Field56D>();
        Tag[] tags = this.tags("56D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field56D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Loop1> getLoop1List() {
        return MT210.getLoop1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<Loop1> getLoop1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocksDelimitedWithOptionalTail(Loop1.START, Loop1.END, Loop1.TAIL)) != null && !blocks.isEmpty()) {
            ArrayList<Loop1> result = new ArrayList<Loop1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                result.add(new Loop1(b));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Deprecated
    public List<SequenceA> getSequenceAList() {
        return MT210.getSequenceAList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    @Deprecated
    public static List<SequenceA> getSequenceAList(SwiftTagListBlock parentSequence) {
        ArrayList<SequenceA> result = new ArrayList<SequenceA>();
        MT210.getLoop1List(parentSequence).forEach(s -> result.add(new SequenceA((Loop1)s)));
        return result;
    }

    @Deprecated
    public static class SequenceA
    extends SwiftTagListBlock {
        private SequenceA(Loop1 content) {
            super(content.getTags());
        }
    }

    public static class Loop1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"21"};
        protected static final String[] END = new String[]{"32B"};
        protected static final String[] TAIL = new String[]{"50C", "50F", "50", "52A", "52D", "56A", "56D"};

        private Loop1() {
            super(new ArrayList<Tag>());
        }

        private Loop1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static Loop1 newInstance(Tag ... tags) {
            return Loop1.newInstance(0, 0, tags);
        }

        public static Loop1 newInstance(int start, int end, Tag ... tags) {
            Loop1 result = new Loop1();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

