/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt3xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessageUtils;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field14D;
import com.prowidesoftware.swift.model.field.Field15A;
import com.prowidesoftware.swift.model.field.Field15B;
import com.prowidesoftware.swift.model.field.Field15C;
import com.prowidesoftware.swift.model.field.Field15D;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field21N;
import com.prowidesoftware.swift.model.field.Field22A;
import com.prowidesoftware.swift.model.field.Field22C;
import com.prowidesoftware.swift.model.field.Field30F;
import com.prowidesoftware.swift.model.field.Field30G;
import com.prowidesoftware.swift.model.field.Field30V;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field33E;
import com.prowidesoftware.swift.model.field.Field34B;
import com.prowidesoftware.swift.model.field.Field36;
import com.prowidesoftware.swift.model.field.Field37L;
import com.prowidesoftware.swift.model.field.Field37M;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53D;
import com.prowidesoftware.swift.model.field.Field53J;
import com.prowidesoftware.swift.model.field.Field56A;
import com.prowidesoftware.swift.model.field.Field56D;
import com.prowidesoftware.swift.model.field.Field56J;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field57J;
import com.prowidesoftware.swift.model.field.Field58A;
import com.prowidesoftware.swift.model.field.Field58D;
import com.prowidesoftware.swift.model.field.Field58J;
import com.prowidesoftware.swift.model.field.Field71F;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field82A;
import com.prowidesoftware.swift.model.field.Field82D;
import com.prowidesoftware.swift.model.field.Field82J;
import com.prowidesoftware.swift.model.field.Field83A;
import com.prowidesoftware.swift.model.field.Field83D;
import com.prowidesoftware.swift.model.field.Field83J;
import com.prowidesoftware.swift.model.field.Field86A;
import com.prowidesoftware.swift.model.field.Field86D;
import com.prowidesoftware.swift.model.field.Field86J;
import com.prowidesoftware.swift.model.field.Field87A;
import com.prowidesoftware.swift.model.field.Field87D;
import com.prowidesoftware.swift.model.field.Field87J;
import com.prowidesoftware.swift.model.field.Field94A;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT350
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT350.class.getName());
    public static final String NAME = "350";

    public MT350(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT350(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT350 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT350(m);
    }

    public MT350() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT350(String sender, String receiver) {
        super(350, sender, receiver);
    }

    public MT350(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT350.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT350 object from FIN content with a Service Message. Check if the MT350 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT350 object from FIN content with message type " + param.getType());
        }
    }

    public static MT350 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT350(fin);
    }

    public MT350(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT350 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT350(stream);
    }

    public MT350(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT350 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT350(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT350 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT350 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT350 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT350 fromJson(String json) {
        return (MT350)AbstractMT.fromJson(json);
    }

    public Field15A getField15A() {
        Tag t = this.tag("15A");
        if (t != null) {
            return new Field15A(t.getValue());
        }
        return null;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field22A getField22A() {
        Tag t = this.tag("22A");
        if (t != null) {
            return new Field22A(t.getValue());
        }
        return null;
    }

    public Field94A getField94A() {
        Tag t = this.tag("94A");
        if (t != null) {
            return new Field94A(t.getValue());
        }
        return null;
    }

    public Field22C getField22C() {
        Tag t = this.tag("22C");
        if (t != null) {
            return new Field22C(t.getValue());
        }
        return null;
    }

    public Field21N getField21N() {
        Tag t = this.tag("21N");
        if (t != null) {
            return new Field21N(t.getValue());
        }
        return null;
    }

    public Field82A getField82A() {
        Tag t = this.tag("82A");
        if (t != null) {
            return new Field82A(t.getValue());
        }
        return null;
    }

    public Field82D getField82D() {
        Tag t = this.tag("82D");
        if (t != null) {
            return new Field82D(t.getValue());
        }
        return null;
    }

    public Field82J getField82J() {
        Tag t = this.tag("82J");
        if (t != null) {
            return new Field82J(t.getValue());
        }
        return null;
    }

    public Field87A getField87A() {
        Tag t = this.tag("87A");
        if (t != null) {
            return new Field87A(t.getValue());
        }
        return null;
    }

    public Field87D getField87D() {
        Tag t = this.tag("87D");
        if (t != null) {
            return new Field87D(t.getValue());
        }
        return null;
    }

    public Field87J getField87J() {
        Tag t = this.tag("87J");
        if (t != null) {
            return new Field87J(t.getValue());
        }
        return null;
    }

    public Field83A getField83A() {
        Tag t = this.tag("83A");
        if (t != null) {
            return new Field83A(t.getValue());
        }
        return null;
    }

    public Field83D getField83D() {
        Tag t = this.tag("83D");
        if (t != null) {
            return new Field83D(t.getValue());
        }
        return null;
    }

    public Field83J getField83J() {
        Tag t = this.tag("83J");
        if (t != null) {
            return new Field83J(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public Field15B getField15B() {
        Tag t = this.tag("15B");
        if (t != null) {
            return new Field15B(t.getValue());
        }
        return null;
    }

    public Field30G getField30G() {
        Tag t = this.tag("30G");
        if (t != null) {
            return new Field30G(t.getValue());
        }
        return null;
    }

    public Field32B getField32B() {
        Tag t = this.tag("32B");
        if (t != null) {
            return new Field32B(t.getValue());
        }
        return null;
    }

    public Field30V getField30V() {
        Tag t = this.tag("30V");
        if (t != null) {
            return new Field30V(t.getValue());
        }
        return null;
    }

    public Field37M getField37M() {
        Tag t = this.tag("37M");
        if (t != null) {
            return new Field37M(t.getValue());
        }
        return null;
    }

    public Field14D getField14D() {
        Tag t = this.tag("14D");
        if (t != null) {
            return new Field14D(t.getValue());
        }
        return null;
    }

    public Field30F getField30F() {
        Tag t = this.tag("30F");
        if (t != null) {
            return new Field30F(t.getValue());
        }
        return null;
    }

    public Field15C getField15C() {
        Tag t = this.tag("15C");
        if (t != null) {
            return new Field15C(t.getValue());
        }
        return null;
    }

    public Field53A getField53A() {
        Tag t = this.tag("53A");
        if (t != null) {
            return new Field53A(t.getValue());
        }
        return null;
    }

    public Field53D getField53D() {
        Tag t = this.tag("53D");
        if (t != null) {
            return new Field53D(t.getValue());
        }
        return null;
    }

    public Field53J getField53J() {
        Tag t = this.tag("53J");
        if (t != null) {
            return new Field53J(t.getValue());
        }
        return null;
    }

    public Field86A getField86A() {
        Tag t = this.tag("86A");
        if (t != null) {
            return new Field86A(t.getValue());
        }
        return null;
    }

    public Field86D getField86D() {
        Tag t = this.tag("86D");
        if (t != null) {
            return new Field86D(t.getValue());
        }
        return null;
    }

    public Field86J getField86J() {
        Tag t = this.tag("86J");
        if (t != null) {
            return new Field86J(t.getValue());
        }
        return null;
    }

    public Field56A getField56A() {
        Tag t = this.tag("56A");
        if (t != null) {
            return new Field56A(t.getValue());
        }
        return null;
    }

    public Field56D getField56D() {
        Tag t = this.tag("56D");
        if (t != null) {
            return new Field56D(t.getValue());
        }
        return null;
    }

    public Field56J getField56J() {
        Tag t = this.tag("56J");
        if (t != null) {
            return new Field56J(t.getValue());
        }
        return null;
    }

    public Field57A getField57A() {
        Tag t = this.tag("57A");
        if (t != null) {
            return new Field57A(t.getValue());
        }
        return null;
    }

    public Field57D getField57D() {
        Tag t = this.tag("57D");
        if (t != null) {
            return new Field57D(t.getValue());
        }
        return null;
    }

    public Field57J getField57J() {
        Tag t = this.tag("57J");
        if (t != null) {
            return new Field57J(t.getValue());
        }
        return null;
    }

    public Field58A getField58A() {
        Tag t = this.tag("58A");
        if (t != null) {
            return new Field58A(t.getValue());
        }
        return null;
    }

    public Field58D getField58D() {
        Tag t = this.tag("58D");
        if (t != null) {
            return new Field58D(t.getValue());
        }
        return null;
    }

    public Field58J getField58J() {
        Tag t = this.tag("58J");
        if (t != null) {
            return new Field58J(t.getValue());
        }
        return null;
    }

    public Field15D getField15D() {
        Tag t = this.tag("15D");
        if (t != null) {
            return new Field15D(t.getValue());
        }
        return null;
    }

    public Field33B getField33B() {
        Tag t = this.tag("33B");
        if (t != null) {
            return new Field33B(t.getValue());
        }
        return null;
    }

    public Field36 getField36() {
        Tag t = this.tag("36");
        if (t != null) {
            return new Field36(t.getValue());
        }
        return null;
    }

    public Field71F getField71F() {
        Tag t = this.tag("71F");
        if (t != null) {
            return new Field71F(t.getValue());
        }
        return null;
    }

    public List<Field34B> getField34B() {
        ArrayList<Field34B> result = new ArrayList<Field34B>();
        Tag[] tags = this.tags("34B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field34B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field37L> getField37L() {
        ArrayList<Field37L> result = new ArrayList<Field37L>();
        Tag[] tags = this.tags("37L");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field37L(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field33E> getField33E() {
        ArrayList<Field33E> result = new ArrayList<Field33E>();
        Tag[] tags = this.tags("33E");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field33E(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("A")) {
            return new SequenceA(map.get("A"));
        }
        return new SequenceA();
    }

    public SequenceB getSequenceB() {
        return this.getSequenceB(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceB getSequenceB(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("B")) {
            return new SequenceB(map.get("B"));
        }
        return new SequenceB();
    }

    public SequenceC getSequenceC() {
        return this.getSequenceC(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceC getSequenceC(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("C")) {
            return new SequenceC(map.get("C"));
        }
        return new SequenceC();
    }

    public SequenceD getSequenceD() {
        return this.getSequenceD(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceD getSequenceD(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("D")) {
            return new SequenceD(map.get("D"));
        }
        return new SequenceD();
    }

    public SequenceD1 getSequenceD1() {
        return this.getSequenceD1(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceD1 getSequenceD1(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            SwiftTagListBlock content = parentSequence.getSubBlockDelimitedWithOptionalTail(SequenceD1.START, SequenceD1.END, SequenceD1.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (content == null) {
                    log.fine("content for sequence SequenceD1: is null");
                } else {
                    log.fine("content for sequence SequenceD1: " + content.tagNamesList());
                }
            }
            if (content == null) {
                return new SequenceD1();
            }
            return new SequenceD1(content);
        }
        return null;
    }

    public static class SequenceD1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"37L"};
        protected static final String[] END = new String[]{"33E"};
        protected static final String[] TAIL = new String[0];

        private SequenceD1() {
            super(new ArrayList<Tag>());
        }

        private SequenceD1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceD1 newInstance(Tag ... tags) {
            return SequenceD1.newInstance(0, 0, tags);
        }

        public static SequenceD1 newInstance(int start, int end, Tag ... tags) {
            SequenceD1 result = new SequenceD1();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class SequenceD
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15D.emptyTag();

        private SequenceD() {
            super(new ArrayList<Tag>());
        }

        private SequenceD(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceD newInstance(Tag ... tags) {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceD newInstance() {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            return result;
        }

        public static SequenceD newInstance(SwiftTagListBlock ... sequences) {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15C.emptyTag();

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC newInstance(Tag ... tags) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceC newInstance() {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            return result;
        }

        public static SequenceC newInstance(SwiftTagListBlock ... sequences) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15B.emptyTag();

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceB newInstance() {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            return result;
        }

        public static SequenceB newInstance(SwiftTagListBlock ... sequences) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15A.emptyTag();

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }
}

