/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.ResolverUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class DateResolver {
    public static List<Calendar> dates(Field f) {
        Objects.requireNonNull(f);
        List<Pair<Character, String>> values = ResolverUtils.findWantedType(f.typesPattern(), "DEFYAUPJ", f.getComponents());
        return values.stream().map(pair -> DateResolver._convert((Character)pair.getKey(), (String)pair.getValue())).collect(Collectors.toList());
    }

    public static Calendar date(Field f) {
        Objects.requireNonNull(f);
        Pair<Character, String> value = ResolverUtils.findFirstWantedType(f.typesPattern(), "DEFYAUPJ", f.getComponents());
        return value != null ? DateResolver._convert((Character)value.getKey(), (String)value.getValue()) : null;
    }

    private static Calendar _convert(Character type, String value) {
        switch (type.charValue()) {
            case 'D': {
                return SwiftFormatUtils.getDate4(value);
            }
            case 'E': {
                return SwiftFormatUtils.getDate2(value);
            }
            case 'F': {
                return SwiftFormatUtils.getDate1(value);
            }
            case 'Y': {
                return SwiftFormatUtils.getYear(value);
            }
            case 'A': {
                return SwiftFormatUtils.getDateTime(value);
            }
            case 'U': {
                return SwiftFormatUtils.getDateTimeShortYear(value);
            }
            case 'P': {
                return SwiftFormatUtils.getDayTime(value);
            }
            case 'J': {
                return SwiftFormatUtils.getMonthDay(value);
            }
        }
        return null;
    }
}

