/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class OptionSPartyField
extends Field {
    public static final String PARSER_PATTERN = ":S/[S]/S/S/S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSSKS";
    public static final String TYPES_PATTERN = "SSSKS";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATA_SOURCE_SCHEME = 2;
    public static final Integer TYPE_OF_ID = 3;
    public static final Integer COUNTRY_CODE = 4;
    public static final Integer ALTERNATE_ID = 5;

    public OptionSPartyField() {
        super(5);
    }

    public OptionSPartyField(String value) {
        super(value);
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent(1, SwiftParseUtils.getTokenFirst(value, ":", "/"));
        this.setComponent(2, SwiftParseUtils.getTokenSecond(value, "/"));
        this.setComponent(3, SwiftParseUtils.getTokenThird(value, "/"));
        String toparse = SwiftParseUtils.getTokenForthLast(value, "/");
        this.setComponent(4, SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent(5, SwiftParseUtils.getTokenSecondLast(toparse, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        result.append("/");
        this.append(result, 5);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field " + this.getName());
        }
        return this.getComponent(component);
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        return "SSSKS";
    }

    @Override
    public final String typesPattern() {
        return "SSSKS";
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public abstract String validatorPattern();

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Data Source Scheme");
        result.add("Type Of ID");
        result.add("Country Code");
        result.add("Alternate ID");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "dataSourceScheme");
        result.put(3, "typeOfID");
        result.put(4, "countryCode");
        result.put(5, "alternateID");
        return result;
    }

    @Override
    public abstract String getName();

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent(2);
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getTypeOfID() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getCountryCode() {
        return this.getComponent(4);
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public String getAlternateID() {
        return this.getComponent(5);
    }
}

