/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field19A
extends Field
implements Serializable,
MonetaryAmountContainer,
GenericField {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "19A";
    public static final String F_19A = "19A";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//[c]SN";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSCN";
    @Deprecated
    public static final String TYPES_PATTERN = "SSCI";
    public static final Integer QUALIFIER = 1;
    public static final Integer SIGN = 2;
    public static final Integer CURRENCY_CODE = 3;
    @Deprecated
    public static final Integer CURRENCY = 3;
    public static final Integer AMOUNT = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field19A() {
        super(4);
    }

    public Field19A(String value) {
        super(value);
    }

    public Field19A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"19A")) {
            throw new IllegalArgumentException("cannot create field 19A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field19A newInstance(Field19A source) {
        Field19A cp = new Field19A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("19A", value);
    }

    public static Tag emptyTag() {
        return new Tag("19A", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        String alpha = SwiftParseUtils.getAlphaPrefix(toparse);
        if (alpha != null && alpha.length() >= 4) {
            this.setComponent2(StringUtils.substring((String)alpha, (int)0, (int)1));
            this.setComponent3(StringUtils.substring((String)alpha, (int)1));
        } else if (toparse != null && toparse.length() >= 3) {
            this.setComponent3(alpha);
        }
        this.setComponent4(SwiftParseUtils.getNumericSuffix(toparse));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 19A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent4AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//[<N>]<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Sign");
        result.add("Currency Code");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "sign");
        result.put(3, "currencyCode");
        result.put(4, "amount");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getSign() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getCurrencyCode() {
        return this.getComponent3();
    }

    @Deprecated
    public String getCurrency() {
        return this.getCurrencyCode();
    }

    public Currency getCurrencyCodeAsCurrency() {
        return this.getComponent3AsCurrency();
    }

    @Deprecated
    public Currency getCurrencyAsCurrency() {
        return this.getCurrencyCodeAsCurrency();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public BigDecimal getComponent4AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(4));
    }

    @Deprecated
    public Number getComponent4AsNumber() {
        return this.getComponent4AsBigDecimal();
    }

    public String getAmount() {
        return this.getComponent4();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent4AsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getComponent4AsNumber();
    }

    public Field19A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field19A setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field19A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field19A setSign(String component2) {
        return this.setComponent2(component2);
    }

    public Field19A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field19A setComponent3(Currency component3) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(component3));
        return this;
    }

    public Field19A setCurrencyCode(String component3) {
        return this.setComponent3(component3);
    }

    public Field19A setCurrencyCode(Currency component3) {
        return this.setComponent3(component3);
    }

    @Deprecated
    public Field19A setCurrency(String component3) {
        return this.setCurrencyCode(component3);
    }

    @Deprecated
    public Field19A setCurrency(Currency component3) {
        return this.setCurrencyCode(component3);
    }

    public Field19A setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field19A setComponent4(BigDecimal component4) {
        this.setComponent(4, SwiftFormatUtils.getBigDecimal(component4));
        return this;
    }

    public Field19A setComponent4(Number component4) {
        if (component4 instanceof BigDecimal) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal((BigDecimal)component4));
        } else if (component4 instanceof BigInteger) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component4)));
        } else if (component4 instanceof Long || component4 instanceof Integer) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.longValue())));
        } else if (component4 != null) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.doubleValue())));
        } else {
            this.setComponent(4, null);
        }
        return this;
    }

    public Field19A setAmount(String component4) {
        return this.setComponent4(component4);
    }

    public Field19A setAmount(BigDecimal component4) {
        return this.setComponent4(component4);
    }

    public Field19A setAmount(Number component4) {
        return this.setComponent4(component4);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "19A";
    }

    public static Field19A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("19A");
        if (t == null) {
            return null;
        }
        return new Field19A(t);
    }

    public static Field19A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field19A.get(msg.getBlock4());
    }

    public static List<Field19A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field19A.getAll(msg.getBlock4());
    }

    public static List<Field19A> getAll(SwiftTagListBlock block) {
        ArrayList<Field19A> result = new ArrayList<Field19A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("19A");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field19A(f));
            }
        }
        return result;
    }

    public static Field19A fromJson(String json) {
        Field19A field = new Field19A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent2(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent3(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("currencyCode") != null) {
            field.setComponent3(jsonObject.get("currencyCode").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent4(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

