/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt1xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field50A;
import com.prowidesoftware.swift.model.field.Field50F;
import com.prowidesoftware.swift.model.field.Field50K;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52B;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field53D;
import com.prowidesoftware.swift.model.field.Field54A;
import com.prowidesoftware.swift.model.field.Field54B;
import com.prowidesoftware.swift.model.field.Field54D;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field59F;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT110
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT110.class.getName());
    public static final String NAME = "110";

    public MT110(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT110(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT110 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT110(m);
    }

    public MT110() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT110(String sender, String receiver) {
        super(110, sender, receiver);
    }

    public MT110(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT110.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT110 object from FIN content with a Service Message. Check if the MT110 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT110 object from FIN content with message type " + param.getType());
        }
    }

    public static MT110 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT110(fin);
    }

    public MT110(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT110 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT110(stream);
    }

    public MT110(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT110 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT110(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT110 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT110 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT110 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT110 fromJson(String json) {
        return (MT110)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field53A getField53A() {
        Tag t = this.tag("53A");
        if (t != null) {
            return new Field53A(t.getValue());
        }
        return null;
    }

    public Field53B getField53B() {
        Tag t = this.tag("53B");
        if (t != null) {
            return new Field53B(t.getValue());
        }
        return null;
    }

    public Field53D getField53D() {
        Tag t = this.tag("53D");
        if (t != null) {
            return new Field53D(t.getValue());
        }
        return null;
    }

    public Field54A getField54A() {
        Tag t = this.tag("54A");
        if (t != null) {
            return new Field54A(t.getValue());
        }
        return null;
    }

    public Field54B getField54B() {
        Tag t = this.tag("54B");
        if (t != null) {
            return new Field54B(t.getValue());
        }
        return null;
    }

    public Field54D getField54D() {
        Tag t = this.tag("54D");
        if (t != null) {
            return new Field54D(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field21(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field30> getField30() {
        ArrayList<Field30> result = new ArrayList<Field30>();
        Tag[] tags = this.tags("30");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field30(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32A> getField32A() {
        ArrayList<Field32A> result = new ArrayList<Field32A>();
        Tag[] tags = this.tags("32A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field50A> getField50A() {
        ArrayList<Field50A> result = new ArrayList<Field50A>();
        Tag[] tags = this.tags("50A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field50A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field50F> getField50F() {
        ArrayList<Field50F> result = new ArrayList<Field50F>();
        Tag[] tags = this.tags("50F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field50F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field50K> getField50K() {
        ArrayList<Field50K> result = new ArrayList<Field50K>();
        Tag[] tags = this.tags("50K");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field50K(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field52A> getField52A() {
        ArrayList<Field52A> result = new ArrayList<Field52A>();
        Tag[] tags = this.tags("52A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field52A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field52B> getField52B() {
        ArrayList<Field52B> result = new ArrayList<Field52B>();
        Tag[] tags = this.tags("52B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field52B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field52D> getField52D() {
        ArrayList<Field52D> result = new ArrayList<Field52D>();
        Tag[] tags = this.tags("52D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field52D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field59F> getField59F() {
        ArrayList<Field59F> result = new ArrayList<Field59F>();
        Tag[] tags = this.tags("59F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field59F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field59> getField59() {
        ArrayList<Field59> result = new ArrayList<Field59>();
        Tag[] tags = this.tags("59");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field59(tag.getValue()));
            }
        }
        return result;
    }

    public List<Loop1> getLoop1List() {
        return MT110.getLoop1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<Loop1> getLoop1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocksDelimitedWithOptionalTail(Loop1.START, Loop1.END, Loop1.TAIL)) != null && !blocks.isEmpty()) {
            ArrayList<Loop1> result = new ArrayList<Loop1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                result.add(new Loop1(b));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class Loop1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"21"};
        protected static final String[] END = new String[]{"59F", "59"};
        protected static final String[] TAIL = new String[0];

        private Loop1() {
            super(new ArrayList<Tag>());
        }

        private Loop1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static Loop1 newInstance(Tag ... tags) {
            return Loop1.newInstance(0, 0, tags);
        }

        public static Loop1 newInstance(int start, int end, Tag ... tags) {
            Loop1 result = new Loop1();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

