/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field29A;
import com.prowidesoftware.swift.model.field.Field29B;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field31F;
import com.prowidesoftware.swift.model.field.Field35A;
import com.prowidesoftware.swift.model.field.Field35B;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field83C;
import com.prowidesoftware.swift.model.field.Field87A;
import com.prowidesoftware.swift.model.field.Field87D;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT526
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT526.class.getName());
    public static final String NAME = "526";

    public MT526(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT526(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT526 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT526(m);
    }

    public MT526() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT526(String sender, String receiver) {
        super(526, sender, receiver);
    }

    public MT526(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT526.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT526 object from FIN content with a Service Message. Check if the MT526 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT526 object from FIN content with message type " + param.getType());
        }
    }

    public static MT526 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT526(fin);
    }

    public MT526(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT526 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT526(stream);
    }

    public MT526(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT526 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT526(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT526 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT526 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT526 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT526 fromJson(String json) {
        return (MT526)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field23 getField23() {
        Tag t = this.tag("23");
        if (t != null) {
            return new Field23(t.getValue());
        }
        return null;
    }

    public Field83C getField83C() {
        Tag t = this.tag("83C");
        if (t != null) {
            return new Field83C(t.getValue());
        }
        return null;
    }

    public Field29A getField29A() {
        Tag t = this.tag("29A");
        if (t != null) {
            return new Field29A(t.getValue());
        }
        return null;
    }

    public Field29B getField29B() {
        Tag t = this.tag("29B");
        if (t != null) {
            return new Field29B(t.getValue());
        }
        return null;
    }

    public List<Field35B> getField35B() {
        ArrayList<Field35B> result = new ArrayList<Field35B>();
        Tag[] tags = this.tags("35B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field35B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field35A> getField35A() {
        ArrayList<Field35A> result = new ArrayList<Field35A>();
        Tag[] tags = this.tags("35A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field35A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field30> getField30() {
        ArrayList<Field30> result = new ArrayList<Field30>();
        Tag[] tags = this.tags("30");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field30(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field31F> getField31F() {
        ArrayList<Field31F> result = new ArrayList<Field31F>();
        Tag[] tags = this.tags("31F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field31F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field87A> getField87A() {
        ArrayList<Field87A> result = new ArrayList<Field87A>();
        Tag[] tags = this.tags("87A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field87A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field87D> getField87D() {
        ArrayList<Field87D> result = new ArrayList<Field87D>();
        Tag[] tags = this.tags("87D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field87D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field72> getField72() {
        ArrayList<Field72> result = new ArrayList<Field72>();
        Tag[] tags = this.tags("72");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field72(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            SwiftTagListBlock content = parentSequence.getSubBlockDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (content == null) {
                    log.fine("content for sequence SequenceA: is null");
                } else {
                    log.fine("content for sequence SequenceA: " + content.tagNamesList());
                }
            }
            if (content == null) {
                return new SequenceA();
            }
            return new SequenceA(content);
        }
        return null;
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_NAME = "35B";

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"23"};
        protected static final String[] TAIL = new String[]{"83C", "29A", "29B"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

