/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.ProwideException;
import com.prowidesoftware.swift.io.writer.SwiftWriter;
import com.prowidesoftware.swift.model.Money;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SwiftMessageUtils {
    private static final Logger log = Logger.getLogger(SwiftMessageUtils.class.getName());
    private final SwiftMessage msg;

    @Deprecated
    public SwiftMessageUtils() {
        this(null);
    }

    @Deprecated
    public SwiftMessageUtils(SwiftMessage m) {
        this.msg = m;
    }

    public static List<String> currencyStrings(SwiftMessage m) {
        SwiftBlock4 b4;
        if (m != null && (b4 = m.getBlock4()) != null && !b4.isEmpty()) {
            ArrayList<String> curs = new ArrayList<String>();
            for (Tag t : b4.getTags()) {
                Field f = t.asField();
                if (!(f instanceof CurrencyContainer)) continue;
                CurrencyContainer cc = (CurrencyContainer)((Object)f);
                curs.addAll(cc.currencyStrings());
            }
            return curs;
        }
        return Collections.emptyList();
    }

    public static SwiftTagListBlock removeInnerSequences(SwiftTagListBlock sequence) throws IllegalArgumentException {
        if (sequence == null || sequence.size() < 3) {
            return sequence;
        }
        Tag start = sequence.getTag(0);
        Tag end = sequence.getTag(sequence.size() - 1);
        if (!StringUtils.equals((CharSequence)"16R", (CharSequence)start.getName())) {
            throw new IllegalArgumentException("Starting tag of sequence must be 16R (and was " + start.getName() + ")");
        }
        if (!StringUtils.equals((CharSequence)"16S", (CharSequence)end.getName())) {
            throw new IllegalArgumentException("Ending tag of sequence must be 16S (and was " + end.getName() + ")");
        }
        if (!StringUtils.equals((CharSequence)start.getValue(), (CharSequence)end.getValue())) {
            throw new IllegalArgumentException("The qualifier of the starting block " + start + " must match the qualifier of the ending block " + end);
        }
        SwiftTagListBlock result = new SwiftTagListBlock();
        String qualifier = null;
        for (int i = 0; i < sequence.getTags().size(); ++i) {
            Tag t = sequence.getTags().get(i);
            if (i > 0 && qualifier == null && StringUtils.equals((CharSequence)t.getName(), (CharSequence)"16R")) {
                qualifier = t.getValue();
                continue;
            }
            if (qualifier != null && StringUtils.equals((CharSequence)t.getName(), (CharSequence)"16S") && StringUtils.equals((CharSequence)t.getValue(), (CharSequence)qualifier)) {
                qualifier = null;
                continue;
            }
            if (qualifier != null) continue;
            result.append(t);
        }
        return result;
    }

    public static Calendar valueDate(SwiftMessage m) {
        SwiftBlock4 b4;
        if (m != null && (b4 = m.getBlock4()) != null && !b4.isEmpty()) {
            Tag t = null;
            Field f = null;
            if (m.isType(101, 104, 107, 201, 203, 204, 207, 210, 604, 605)) {
                t = b4.getTagByName("30");
            } else if (m.isType(102, 103, 200, 202, 205, 400, 450, 455, 800, 802, 900, 910)) {
                t = b4.getTagByName("32A");
            } else if (m.isType(300, 304, 320, 330, 350, 620)) {
                t = b4.getTagByName("30V");
            } else if (m.isType(370)) {
                SwiftTagListBlock seq = b4.getSubBlock("NETPOS");
                if (seq != null) {
                    f = seq.getFieldByNumber(98, "NETT");
                }
            } else if (m.isType(456)) {
                t = b4.getTagByName("33D");
            } else if (m.isType(502)) {
                SwiftTagListBlock seq = b4.getSubBlock("AMT");
                if (seq != null) {
                    f = seq.getFieldByNumber(98, "VALU");
                }
            } else if (m.isType(509)) {
                SwiftTagListBlock seq = b4.getSubBlock("TRADE");
                if (seq != null) {
                    f = seq.getFieldByNumber(98, "SETT");
                }
            } else if (m.isType(513)) {
                SwiftTagListBlock seq = b4.getSubBlock("ORDRDET");
                if (seq != null) {
                    f = seq.getFieldByNumber(98, "SETT");
                }
            } else if (m.isType(514, 515, 518)) {
                SwiftTagListBlock seq = b4.getSubBlock("CONFDET");
                if (seq != null) {
                    f = seq.getFieldByNumber(98, "SETT");
                }
            } else if (m.isType(540, 541, 542, 543, 544, 545, 546, 547, 586)) {
                SwiftTagListBlock seq = b4.getSubBlock("TRADDET");
                if (seq != null) {
                    f = seq.getFieldByNumber(98, "SETT");
                } else {
                    SwiftTagListBlock seq2 = b4.getSubBlock("AMT");
                    if (seq2 != null) {
                        f = seq2.getFieldByNumber(98, "VALU");
                    }
                }
            } else if (m.isType(537)) {
                SwiftTagListBlock seq = b4.getSubBlock("TRANSDET");
                if (seq != null) {
                    f = seq.getFieldByNumber(98, "EXSE");
                }
            } else if (m.isType(548)) {
                SwiftTagListBlock seq = b4.getSubBlock("SETTRAN");
                if (seq != null) {
                    f = seq.getFieldByNumber(70, "SPRO");
                }
            } else if (m.isType(564)) {
                SwiftTagListBlock seq = b4.getSubBlock("CASHMOVE");
                if (seq != null) {
                    f = seq.getFieldByNumber(98, "PAYD");
                }
            } else if (m.isType(566)) {
                SwiftTagListBlock seq = b4.getSubBlock("CASHMOVE");
                if (seq != null) {
                    f = seq.getFieldByNumber(98, "POST");
                }
            } else if (m.isType(730, 768, 769)) {
                t = b4.getTagByName("32D");
            } else if (m.isType(734, 752, 756)) {
                t = b4.getTagByName("33A");
            } else if (m.isType(742, 754)) {
                t = b4.getTagByName("34A");
            } else if (m.isType(942, 950, 970, 972)) {
                t = b4.getTagByName("61");
            } else if (m.isType(305)) {
                t = b4.getTagByName("31G");
            } else if (m.isType(306)) {
                t = b4.getTagByName("30V");
            } else if (m.isType(340, 341)) {
                t = b4.getTagByName("30F");
            } else if (m.isType(360, 361, 362)) {
                t = b4.getTagByName("30V");
            }
            if (t != null) {
                f = t.asField();
            }
            if (f != null && f instanceof DateContainer) {
                return ((DateContainer)((Object)f)).dates().get(0);
            }
        }
        return null;
    }

    public static Calendar tradeDate(SwiftMessage m) {
        SwiftBlock4 b4;
        if (m != null && (b4 = m.getBlock4()) != null && !b4.isEmpty()) {
            Field f = m.getBlock4().getFieldByName("30T");
            if (f == null) {
                f = m.getBlock4().getFieldByNumber(98, "TRAD");
            }
            if (f != null && f instanceof DateContainer) {
                return ((DateContainer)((Object)f)).dates().get(0);
            }
        }
        return null;
    }

    public static String calculateChecksum(SwiftMessage model) {
        if (model != null) {
            StringWriter writer = new StringWriter();
            SwiftWriter.writeMessage(model, writer, true);
            String fin = writer.getBuffer().toString();
            return SwiftMessageUtils.md5(fin);
        }
        return null;
    }

    public static String calculateChecksum(SwiftBlock4 b4) {
        if (b4 != null) {
            StringWriter writer = new StringWriter();
            SwiftWriter.writeBlock4(b4, writer);
            String fin = writer.getBuffer().toString();
            return SwiftMessageUtils.md5(fin);
        }
        return null;
    }

    private static String md5(String text) {
        try {
            byte[] bytesOfMessage = text.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] thedigest = md.digest(bytesOfMessage);
            StringBuilder buff = new StringBuilder();
            for (byte b : thedigest) {
                String conversion = Integer.toString(b & 0xFF, 16);
                while (conversion.length() < 2) {
                    conversion = "0" + conversion;
                }
                buff.append(conversion);
            }
            return buff.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.FINEST, e.getMessage(), e);
            return null;
        }
    }

    public static Map<String, SwiftTagListBlock> splitByField15(SwiftMessage msg) {
        if (msg != null && msg.getBlock4() != null) {
            return SwiftMessageUtils.splitByField15(msg.getBlock4());
        }
        return new HashMap<String, SwiftTagListBlock>();
    }

    public static Map<String, SwiftTagListBlock> splitByField15(SwiftTagListBlock block) {
        HashMap<String, SwiftTagListBlock> result = new HashMap<String, SwiftTagListBlock>();
        if (block != null) {
            SwiftTagListBlock currentList = null;
            for (Tag t : block.getTags()) {
                String letter;
                if (t.getNumber() == 15 && (letter = t.getLetterOption()) != null && letter.length() == 1) {
                    SwiftTagListBlock thisList = new SwiftTagListBlock();
                    result.put(letter, thisList);
                    currentList = thisList;
                }
                if (currentList == null) continue;
                currentList.append(t);
            }
        }
        return result;
    }

    public static List<SwiftTagListBlock> splitByField15(SwiftMessage msg, String letterOption) {
        if (msg != null && msg.getBlock4() != null) {
            return SwiftMessageUtils.splitByField15(msg.getBlock4(), letterOption);
        }
        return Collections.emptyList();
    }

    public static List<SwiftTagListBlock> splitByField15(SwiftTagListBlock block, String letterOption) {
        Validate.notNull((Object)letterOption);
        Validate.isTrue((StringUtils.length((CharSequence)letterOption) == 1 ? 1 : 0) != 0, (String)"letter option must be only one character", (Object[])new Object[0]);
        ArrayList<SwiftTagListBlock> result = new ArrayList<SwiftTagListBlock>();
        if (block != null) {
            SwiftTagListBlock currentList = null;
            for (Tag t : block.getTags()) {
                String letter;
                if (t.getNumber() == 15 && (letter = t.getLetterOption()) != null && letter.length() == 1) {
                    if (letter.equals(letterOption)) {
                        SwiftTagListBlock thisList = new SwiftTagListBlock();
                        result.add(thisList);
                        currentList = thisList;
                    } else {
                        currentList = null;
                    }
                }
                if (currentList == null) continue;
                currentList.append(t);
            }
        }
        return result;
    }

    public static String reference(SwiftMessage m) {
        if (m != null) {
            String mur;
            SwiftBlock4 b4 = m.getBlock4();
            if (b4 != null && !b4.isEmpty()) {
                Tag t = b4.getTagByName("20");
                if (t != null) {
                    return t.getValue();
                }
                Field f = b4.getFieldByNumber(20, "SEME");
                if (f != null) {
                    return f.getComponent(2);
                }
                Tag murBlock4 = b4.getTagByName("108");
                if (murBlock4 != null) {
                    return murBlock4.getValue();
                }
            }
            if ((mur = m.getMUR()) != null) {
                return mur;
            }
        }
        return null;
    }

    public static SwiftTagListBlock join(List<? extends SwiftTagListBlock> sequences) {
        if (sequences == null || sequences.isEmpty()) {
            return SwiftTagListBlock.EMPTY_LIST;
        }
        SwiftTagListBlock[] seqArray = new SwiftTagListBlock[sequences.size()];
        sequences.toArray(seqArray);
        return SwiftMessageUtils.join(seqArray);
    }

    public static SwiftTagListBlock join(SwiftTagListBlock ... sequences) {
        if (sequences == null || sequences.length == 0) {
            return SwiftTagListBlock.EMPTY_LIST;
        }
        SwiftTagListBlock result = new SwiftTagListBlock();
        for (SwiftTagListBlock b : sequences) {
            result.getTags().addAll(b.getTags());
        }
        return result;
    }

    public static SwiftTagListBlock createSubsequenceWithParents(Class<? extends AbstractMT> mt, String sequenceName, Tag ... tags) {
        log.finer("Create sequence " + sequenceName);
        SwiftTagListBlock result = new SwiftTagListBlock();
        result.append(tags);
        for (int i = sequenceName.length(); i >= 1; --i) {
            String sn = StringUtils.substring((String)sequenceName, (int)0, (int)i);
            SwiftTagListBlock newresult = SwiftMessageUtils.createSequenceSingle(mt, sn, result.asTagArray());
            log.finer(sn + " => " + newresult);
            result.setTags(newresult.getTags());
        }
        return result;
    }

    public static SwiftTagListBlock createSequenceSingle(Class<? extends AbstractMT> mt, String sequenceName, Tag ... tags) {
        String cn = mt.getName() + "$Sequence" + sequenceName;
        try {
            Class<?> subSequenceClass = Class.forName(cn);
            Method method = subSequenceClass.getMethod("newInstance", Tag[].class);
            return (SwiftTagListBlock)method.invoke(null, new Object[]{tags});
        }
        catch (Exception e) {
            String message = "Reflection error: mt=" + mt.getName() + ", sequenceName=" + sequenceName + ", tags=" + Arrays.toString(tags) + " - " + e.getMessage();
            log.log(Level.WARNING, message, e);
            throw new ProwideException(message);
        }
    }

    public static Money money(SwiftMessage m) {
        SwiftTagListBlock seq;
        if (m == null || m.isServiceMessage21()) {
            return null;
        }
        SwiftBlock4 b4 = m.getBlock4();
        if (b4 == null || b4.isEmpty()) {
            return null;
        }
        if (m.isType(102, 103, 200, 202, 205, 256, 450, 455, 643, 644, 646, 734, 802, 900, 910)) {
            return Money.of(b4.getFieldByName("32A"));
        }
        if (m.isType(191, 291, 300, 304, 305, 320, 391, 491, 591, 691, 791, 891, 991, 340, 341, 350, 360, 361, 364, 365, 620, 700, 705, 710, 720, 732, 740, 742, 756)) {
            return Money.of(b4.getFieldByName("32B"));
        }
        if (m.isType(321, 370, 508, 509, 535, 536, 537, 540, 541, 542, 543, 544, 545, 546, 547, 548, 558, 559, 569, 574, 575, 576, 578, 586)) {
            return Money.of(b4.getFieldByName("19A"));
        }
        if (m.isType(330, 362)) {
            return Money.of(b4.getFieldByName("32H"));
        }
        if (m.isType(306, 581, 707, 747)) {
            return Money.of(b4.getFieldByName("34B"));
        }
        if (m.isType(380, 381, 505, 564, 566, 567)) {
            return Money.of(b4.getFieldByName("19B"));
        }
        if (m.isType(800)) {
            return Money.of(b4.getFieldByName("33B"));
        }
        if (m.isType(941)) {
            return Money.of(b4.getFieldByName("62F"));
        }
        if (m.isType(600, 601)) {
            return Money.ofAny(b4, "34P", "34R");
        }
        if (m.isType(609)) {
            return Money.ofAny(b4, "68B", "68C");
        }
        if (m.isType(111, 112, 516, 649) || m.isType(754)) {
            return Money.ofAny(b4, "32A", "32B");
        }
        if (m.isType(190, 290, 390, 490, 590, 690, 790, 890, 990)) {
            return Money.ofAny(b4, "32C", "32D");
        }
        if (m.isType(730) || m.isType(768)) {
            return Money.ofAny(b4, "32B", "32D");
        }
        if (m.isType(400, 410)) {
            return Money.ofAny(b4, "32A", "32B", "32K");
        }
        if (m.isType(430)) {
            return Money.ofAny(b4, "33A", "33K", "32A", "32K");
        }
        if (m.isType(750)) {
            return Money.ofAny(b4, "34B", "32B");
        }
        if (m.isType(752)) {
            return Money.ofAny(b4, "33A", "33B", "32B");
        }
        if (m.isType(769)) {
            return Money.ofAny(b4, "32B", "32D", "33B", "34B");
        }
        if (m.isType(940, 950, 970)) {
            return Money.ofAny(b4, "62F", "62M");
        }
        if (m.isType(101, 201, 203, 204, 207, 210)) {
            return Money.ofSum(b4.getFieldsByName("32B"));
        }
        if (m.isType(110, 416, 420, 422, 456)) {
            return Money.ofSum(b4.getFieldsByName("32a"));
        }
        if (m.isType(509)) {
            return Money.ofSum(b4.getFieldsByName("19A"));
        }
        if (m.isType(112)) {
            return Money.ofSum(b4.getFieldsByName("32A"));
        }
        if (m.isType(801)) {
            return Money.ofSum(b4.getFieldsByName("33B"));
        }
        if (m.isType(824)) {
            return Money.ofSum(b4.getFieldsByName("68A"));
        }
        if (m.isType(104, 107)) {
            Tag t;
            int startIndexOfC;
            int last59 = b4.indexOfAnyLast("59", "59A");
            if (last59 >= 0 && (startIndexOfC = b4.indexOfAnyFirstAfterIndex(last59, "32B")) >= 0 && (t = b4.getTags().get(startIndexOfC)) != null) {
                return Money.of(t.asField());
            }
        } else if (m.isType(502, 513)) {
            SwiftTagListBlock seq2 = b4.getSubBlock("ORDRDET");
            if (seq2 != null) {
                return Money.of(seq2.getFieldByName("19A"));
            }
        } else if (m.isType(514, 515, 518)) {
            SwiftTagListBlock seq3 = b4.getSubBlock("CONFDET");
            if (seq3 != null) {
                return Money.of(seq3.getFieldByName("19A"));
            }
        } else if (m.isType(503, 504, 506)) {
            SwiftTagListBlock seq4 = b4.getSubBlock("SUMM");
            if (seq4 != null) {
                return Money.of(seq4.getFieldByName("19B"));
            }
        } else if (m.isType(527) && (seq = b4.getSubBlock("DEALTRAN")) != null) {
            return Money.of(seq.getFieldByName("19A"));
        }
        return null;
    }

    @Deprecated
    public List<String> currencyStrings() {
        return SwiftMessageUtils.currencyStrings(this.msg);
    }

    @Deprecated
    public Calendar valueDate() {
        return SwiftMessageUtils.valueDate(this.msg);
    }

    @Deprecated
    public final String reference() {
        return SwiftMessageUtils.reference(this.msg);
    }

    @Deprecated
    protected Money money() {
        return SwiftMessageUtils.money(this.msg);
    }
}

